/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleDTOEndpoint;
import org.apache.nifi.cluster.manager.AssetsEntityMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.AssetEntity;
import org.apache.nifi.web.api.entity.AssetsEntity;

public class AssetsEndpointMerger
extends AbstractSingleDTOEndpoint<AssetsEntity, Collection<AssetEntity>> {
    private static final Pattern ASSETS_URI = Pattern.compile("/nifi-api/parameter-contexts/[a-f0-9\\-]{36}/assets");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && ASSETS_URI.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<AssetsEntity> getEntityClass() {
        return AssetsEntity.class;
    }

    @Override
    protected Collection<AssetEntity> getDto(AssetsEntity entity) {
        return entity.getAssets();
    }

    @Override
    protected void mergeResponses(Collection<AssetEntity> clientDto, Map<NodeIdentifier, Collection<AssetEntity>> dtoMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        AssetsEntityMerger.mergeResponses(clientDto, dtoMap);
    }
}

