/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.replication.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ReplicatedResponse
extends Response {
    private static final int MAXIMUM_BUFFER_SIZE = 0x100000;
    private static final int CONTENT_LENGTH_UNKNOWN = -1;
    private final ObjectMapper codec;
    private final InputStream responseBody;
    private final MultivaluedMap<String, String> responseHeaders;
    private final URI location;
    private final int statusCode;
    private final Runnable closeCallback;
    private final int contentLength;
    private final JsonFactory jsonFactory = new JsonFactory();
    private final byte[] bufferedResponseBody;

    public ReplicatedResponse(ObjectMapper codec, InputStream responseBody, MultivaluedMap<String, String> responseHeaders, URI location, int statusCode, int contentLength, Runnable closeCallback) {
        this.codec = codec;
        this.responseBody = responseBody;
        this.responseHeaders = responseHeaders;
        this.location = location;
        this.statusCode = statusCode;
        this.closeCallback = closeCallback;
        if (contentLength == -1 || contentLength > 0x100000) {
            this.bufferedResponseBody = null;
            this.contentLength = -1;
        } else {
            this.bufferedResponseBody = ReplicatedResponse.readResponseBody(responseBody, location, statusCode);
            this.contentLength = this.bufferedResponseBody.length;
        }
    }

    public int getStatus() {
        return this.statusCode;
    }

    public Response.StatusType getStatusInfo() {
        return Response.Status.fromStatusCode((int)this.getStatus());
    }

    public Object getEntity() {
        InputStream responseBodyStream = this.getResponseBodyStream();
        try {
            JsonParser parser = this.jsonFactory.createParser(responseBodyStream);
            parser.setCodec((ObjectCodec)this.codec);
            return parser.readValueAs(Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse response", e);
        }
    }

    public <T> T readEntity(Class<T> entityType) {
        InputStream responseBodyStream = this.getResponseBodyStream();
        if (InputStream.class.equals(entityType)) {
            return (T)responseBodyStream;
        }
        if (String.class.equals(entityType)) {
            try {
                byte[] responseBytes = responseBodyStream.readAllBytes();
                return (T)new String(responseBytes, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Read Replicated Response Body to String failed for %s".formatted(this.location), e);
            }
        }
        try {
            JsonParser parser = this.jsonFactory.createParser(responseBodyStream);
            parser.setCodec((ObjectCodec)this.codec);
            return (T)parser.readValueAs(entityType);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse response as entity of type " + String.valueOf(entityType), e);
        }
    }

    public <T> T readEntity(GenericType<T> entityType) {
        throw new UnsupportedOperationException();
    }

    public <T> T readEntity(Class<T> entityType, Annotation[] annotations) {
        throw new UnsupportedOperationException();
    }

    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) {
        throw new UnsupportedOperationException();
    }

    public boolean hasEntity() {
        return true;
    }

    public boolean bufferEntity() {
        return true;
    }

    public void close() {
        if (this.closeCallback != null) {
            this.closeCallback.run();
        }
    }

    public MediaType getMediaType() {
        return MediaType.APPLICATION_JSON_TYPE;
    }

    public Locale getLanguage() {
        return null;
    }

    public int getLength() {
        return this.contentLength;
    }

    public Set<String> getAllowedMethods() {
        String allowHeader = this.getHeaderString("Allow");
        if (allowHeader == null || allowHeader.trim().isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> allowed = new HashSet<String>();
        for (String allow : allowHeader.split(",")) {
            String trimmed = allow.trim().toUpperCase();
            if (trimmed.isEmpty()) continue;
            allowed.add(trimmed);
        }
        return allowed;
    }

    public Map<String, NewCookie> getCookies() {
        return Collections.emptyMap();
    }

    public EntityTag getEntityTag() {
        return null;
    }

    public Date getDate() {
        return null;
    }

    public Date getLastModified() {
        return null;
    }

    public URI getLocation() {
        return this.location;
    }

    public Set<Link> getLinks() {
        return Collections.emptySet();
    }

    public boolean hasLink(String relation) {
        return false;
    }

    public Link getLink(String relation) {
        return null;
    }

    public Link.Builder getLinkBuilder(String relation) {
        return null;
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return new MultivaluedHashMap();
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.responseHeaders;
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        return this.responseHeaders;
    }

    public String getHeaderString(String name) {
        String headerValue = (String)this.responseHeaders.getFirst((Object)name);
        if (headerValue != null) {
            return headerValue;
        }
        return (String)this.responseHeaders.getFirst((Object)name.toLowerCase());
    }

    private InputStream getResponseBodyStream() {
        InputStream responseBodyStream = this.bufferedResponseBody == null ? this.responseBody : new ByteArrayInputStream(this.bufferedResponseBody);
        return responseBodyStream;
    }

    private static byte[] readResponseBody(InputStream inputStream, URI location, int statusCode) {
        try {
            return inputStream.readAllBytes();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Buffering Replicated Response Body failed %s HTTP %d".formatted(location, statusCode), e);
        }
    }
}

