/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.FlowRegistryClientsEntityMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.FlowRegistryClientEntity;
import org.apache.nifi.web.api.entity.FlowRegistryClientsEntity;

public class FlowRegistryClientsEndpointMerger
implements EndpointResponseMerger {
    public static final String FLOW_REGISTRY_URI = "/nifi-api/flow/registries";
    public static final String CONTROLLER_REGISTRY_URI = "/nifi-api/controller/registry-clients";

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && (FLOW_REGISTRY_URI.equals(uri.getPath()) || CONTROLLER_REGISTRY_URI.equals(uri.getPath()));
    }

    @Override
    public NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Mapper of type " + this.getClass().getSimpleName() + " to map responses for URI " + String.valueOf(uri) + ", HTTP Method " + method);
        }
        FlowRegistryClientsEntity responseEntity = (FlowRegistryClientsEntity)clientResponse.getClientResponse().readEntity(FlowRegistryClientsEntity.class);
        Set clientEntities = responseEntity.getRegistries();
        HashMap<String, Map<NodeIdentifier, FlowRegistryClientEntity>> entityMap = new HashMap<String, Map<NodeIdentifier, FlowRegistryClientEntity>>();
        for (NodeResponse nodeResponse : successfulResponses) {
            FlowRegistryClientsEntity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (FlowRegistryClientsEntity)nodeResponse.getClientResponse().readEntity(FlowRegistryClientsEntity.class);
            Set nodeFlowRegistryClientEntities = nodeResponseEntity.getRegistries();
            for (FlowRegistryClientEntity nodeFlowRegistryClientEntity : nodeFlowRegistryClientEntities) {
                Map innerMap = entityMap.computeIfAbsent(nodeFlowRegistryClientEntity.getId(), k -> new HashMap());
                innerMap.put(nodeResponse.getNodeId(), nodeFlowRegistryClientEntity);
            }
        }
        FlowRegistryClientsEntityMerger.mergeFlowRegistryClients(clientEntities, entityMap);
        return new NodeResponse(clientResponse, (Entity)responseEntity);
    }
}

