/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.nifi.cluster.manager.ComponentEntityMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.UserGroupDTO;
import org.apache.nifi.web.api.entity.UserGroupEntity;

public class UserGroupEntityMerger
implements ComponentEntityMerger<UserGroupEntity> {
    @Override
    public void merge(UserGroupEntity clientEntity, Map<NodeIdentifier, UserGroupEntity> entityMap) {
        ComponentEntityMerger.super.merge(clientEntity, entityMap);
    }

    @Override
    public void mergeComponents(UserGroupEntity clientEntity, Map<NodeIdentifier, UserGroupEntity> entityMap) {
        UserGroupDTO clientDto = clientEntity.getComponent();
        HashMap<NodeIdentifier, UserGroupDTO> dtoMap = new HashMap<NodeIdentifier, UserGroupDTO>();
        for (Map.Entry<NodeIdentifier, UserGroupEntity> entry : entityMap.entrySet()) {
            UserGroupEntity nodeUserGroupEntity = entry.getValue();
            UserGroupDTO nodeUserGroupDto = nodeUserGroupEntity.getComponent();
            dtoMap.put(entry.getKey(), nodeUserGroupDto);
        }
        UserGroupEntityMerger.mergeDtos(clientDto, dtoMap);
    }

    private static void mergeDtos(UserGroupDTO clientDto, Map<NodeIdentifier, UserGroupDTO> dtoMap) {
        if (clientDto == null) {
            return;
        }
        HashSet accessPolicyEntities = new HashSet(clientDto.getAccessPolicies());
        HashSet userEntities = new HashSet(clientDto.getUsers());
        for (Map.Entry<NodeIdentifier, UserGroupDTO> nodeEntry : dtoMap.entrySet()) {
            UserGroupDTO nodeUserGroup = nodeEntry.getValue();
            if (nodeUserGroup == null) continue;
            accessPolicyEntities.retainAll(nodeUserGroup.getAccessPolicies());
            userEntities.retainAll(nodeUserGroup.getUsers());
        }
        clientDto.setAccessPolicies(accessPolicyEntities);
        clientDto.setUsers(userEntities);
    }
}

