/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.cluster.manager.ComponentEntityMerger;
import org.apache.nifi.cluster.manager.ComponentEntityStatusMerger;
import org.apache.nifi.cluster.manager.PermissionsDtoMerger;
import org.apache.nifi.cluster.manager.StatusMerger;
import org.apache.nifi.cluster.manager.VersionControlInformationEntityMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.groups.StatelessGroupScheduledState;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;
import org.apache.nifi.web.api.dto.status.ProcessGroupStatusDTO;
import org.apache.nifi.web.api.entity.ParameterContextReferenceEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;

public class ProcessGroupEntityMerger
implements ComponentEntityMerger<ProcessGroupEntity>,
ComponentEntityStatusMerger<ProcessGroupStatusDTO> {
    @Override
    public void merge(ProcessGroupEntity clientEntity, Map<NodeIdentifier, ProcessGroupEntity> entityMap) {
        ComponentEntityMerger.super.merge(clientEntity, entityMap);
        HashMap<NodeIdentifier, ProcessGroupDTO> dtoMap = new HashMap<NodeIdentifier, ProcessGroupDTO>();
        for (Map.Entry<NodeIdentifier, ProcessGroupEntity> entry : entityMap.entrySet()) {
            ProcessGroupEntity entity = entry.getValue();
            if (entity != clientEntity) {
                this.mergeStatus(clientEntity.getStatus(), (boolean)clientEntity.getPermissions().getCanRead(), entry.getValue().getStatus(), (boolean)entry.getValue().getPermissions().getCanRead(), entry.getKey());
                this.mergeVersionControlInformation(clientEntity, entity);
            }
            dtoMap.put(entry.getKey(), entity.getComponent());
        }
        ProcessGroupEntityMerger.mergeDtos(clientEntity.getComponent(), dtoMap);
    }

    private static void mergeDtos(ProcessGroupDTO clientDto, Map<NodeIdentifier, ProcessGroupDTO> dtoMap) {
        if (clientDto == null) {
            return;
        }
        ParameterContextReferenceEntity clientParameterContextEntity = clientDto.getParameterContext();
        if (clientParameterContextEntity != null) {
            for (Map.Entry<NodeIdentifier, ProcessGroupDTO> entry : dtoMap.entrySet()) {
                ProcessGroupDTO dto = entry.getValue();
                ParameterContextReferenceEntity parameterContextReferenceEntity = dto.getParameterContext();
                clientDto.setStatelessGroupScheduledState(ProcessGroupEntityMerger.mergeScheduledState(clientDto.getStatelessGroupScheduledState(), dto.getStatelessGroupScheduledState()));
                PermissionsDtoMerger.mergePermissions(clientParameterContextEntity.getPermissions(), parameterContextReferenceEntity.getPermissions());
            }
        }
    }

    private static String mergeScheduledState(String stateAName, String stateBName) {
        StatelessGroupScheduledState stateA = ProcessGroupEntityMerger.getScheduledState(stateAName);
        StatelessGroupScheduledState stateB = ProcessGroupEntityMerger.getScheduledState(stateBName);
        if (stateA == null && stateB == null) {
            return null;
        }
        if (stateA == null) {
            return stateB.name();
        }
        if (stateB == null) {
            return stateA.name();
        }
        if (stateA == StatelessGroupScheduledState.RUNNING || stateB == StatelessGroupScheduledState.RUNNING) {
            return StatelessGroupScheduledState.RUNNING.name();
        }
        return StatelessGroupScheduledState.STOPPED.name();
    }

    private static StatelessGroupScheduledState getScheduledState(String value) {
        if (value == null) {
            return null;
        }
        try {
            return StatelessGroupScheduledState.valueOf((String)value);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void mergeStatus(ProcessGroupStatusDTO clientStatus, boolean clientStatusReadablePermission, ProcessGroupStatusDTO status, boolean statusReadablePermission, NodeIdentifier statusNodeIdentifier) {
        StatusMerger.merge(clientStatus, clientStatusReadablePermission, status, statusReadablePermission, statusNodeIdentifier.getId(), statusNodeIdentifier.getApiAddress(), (Integer)statusNodeIdentifier.getApiPort());
    }

    private void mergeVersionControlInformation(ProcessGroupEntity targetGroup, ProcessGroupEntity toMerge) {
        ProcessGroupDTO targetGroupDto = targetGroup.getComponent();
        ProcessGroupDTO toMergeGroupDto = toMerge.getComponent();
        if (targetGroupDto == null || toMergeGroupDto == null) {
            return;
        }
        VersionControlInformationDTO targetVersionControl = targetGroupDto.getVersionControlInformation();
        VersionControlInformationDTO toMergeVersionControl = toMergeGroupDto.getVersionControlInformation();
        if (targetVersionControl == null) {
            targetGroupDto.setVersionControlInformation(toMergeGroupDto.getVersionControlInformation());
        } else if (toMergeVersionControl != null) {
            VersionControlInformationEntityMerger.updateFlowState(targetVersionControl, toMergeVersionControl);
        }
    }
}

