/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.Collection;
import java.util.Map;
import org.apache.nifi.cluster.manager.NarSummaryDtoMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.NarSummaryDTO;
import org.apache.nifi.web.api.entity.NarSummaryEntity;

public class NarSummariesMerger {
    public static void mergeResponses(Collection<NarSummaryEntity> clientDto, Map<NodeIdentifier, Collection<NarSummaryEntity>> dtoMap) {
        dtoMap.values().forEach(clientDto::retainAll);
        clientDto.stream().map(NarSummaryEntity::getNarSummary).forEach(summaryDTO -> NarSummariesMerger.mergeResponses(summaryDTO, dtoMap));
    }

    public static void mergeResponses(NarSummaryDTO clientDto, Map<NodeIdentifier, Collection<NarSummaryEntity>> dtoMap) {
        for (Collection<NarSummaryEntity> nodeSummaries : dtoMap.values()) {
            for (NarSummaryEntity nodeSummary : nodeSummaries) {
                NarSummaryDTO nodeDto = nodeSummary.getNarSummary();
                if (!clientDto.getIdentifier().equals(nodeDto.getIdentifier())) continue;
                NarSummaryDtoMerger.merge(clientDto, nodeDto);
            }
        }
    }
}

