/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.cluster.manager.ComponentEntityMerger;
import org.apache.nifi.cluster.manager.ErrorMerger;
import org.apache.nifi.cluster.manager.PropertyDescriptorDtoMerger;
import org.apache.nifi.cluster.manager.StatusMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.FlowAnalysisRuleDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.entity.FlowAnalysisRuleEntity;

public class FlowAnalysisRuleEntityMerger
implements ComponentEntityMerger<FlowAnalysisRuleEntity> {
    @Override
    public void merge(FlowAnalysisRuleEntity clientEntity, Map<NodeIdentifier, FlowAnalysisRuleEntity> entityMap) {
        ComponentEntityMerger.super.merge(clientEntity, entityMap);
        for (Map.Entry<NodeIdentifier, FlowAnalysisRuleEntity> entry : entityMap.entrySet()) {
            FlowAnalysisRuleEntity entityStatus = entry.getValue();
            if (clientEntity == entityStatus) continue;
            StatusMerger.merge(clientEntity.getStatus(), entityStatus.getStatus());
        }
    }

    @Override
    public void mergeComponents(FlowAnalysisRuleEntity clientEntity, Map<NodeIdentifier, FlowAnalysisRuleEntity> entityMap) {
        FlowAnalysisRuleDTO clientDto = clientEntity.getComponent();
        HashMap<NodeIdentifier, FlowAnalysisRuleDTO> dtoMap = new HashMap<NodeIdentifier, FlowAnalysisRuleDTO>();
        for (Map.Entry<NodeIdentifier, FlowAnalysisRuleEntity> entry : entityMap.entrySet()) {
            FlowAnalysisRuleEntity nodeFlowAnalysisRuleEntity = entry.getValue();
            FlowAnalysisRuleDTO nodeFlowAnalysisRuleDto = nodeFlowAnalysisRuleEntity.getComponent();
            dtoMap.put(entry.getKey(), nodeFlowAnalysisRuleDto);
        }
        FlowAnalysisRuleEntityMerger.mergeDtos(clientDto, dtoMap);
    }

    private static void mergeDtos(FlowAnalysisRuleDTO clientDto, Map<NodeIdentifier, FlowAnalysisRuleDTO> dtoMap) {
        if (clientDto == null) {
            return;
        }
        HashMap<String, Set<NodeIdentifier>> validationErrorMap = new HashMap<String, Set<NodeIdentifier>>();
        HashMap propertyDescriptorMap = new HashMap();
        for (Map.Entry<NodeIdentifier, FlowAnalysisRuleDTO> nodeEntry : dtoMap.entrySet()) {
            FlowAnalysisRuleDTO nodeFlowAnalysisRule = nodeEntry.getValue();
            if (nodeFlowAnalysisRule == null) continue;
            NodeIdentifier nodeId = nodeEntry.getKey();
            ErrorMerger.mergeErrors(validationErrorMap, nodeId, nodeFlowAnalysisRule.getValidationErrors());
            if (nodeFlowAnalysisRule.getDescriptors() == null) continue;
            nodeFlowAnalysisRule.getDescriptors().values().stream().forEach(propertyDescriptor -> propertyDescriptorMap.computeIfAbsent(propertyDescriptor.getName(), nodeIdToPropertyDescriptor -> new HashMap()).put(nodeId, propertyDescriptor));
        }
        for (Map propertyDescriptorByNodeId : propertyDescriptorMap.values()) {
            Collection nodePropertyDescriptors = propertyDescriptorByNodeId.values();
            if (nodePropertyDescriptors.isEmpty()) continue;
            PropertyDescriptorDTO propertyDescriptor2 = (PropertyDescriptorDTO)nodePropertyDescriptors.iterator().next();
            PropertyDescriptorDTO clientPropertyDescriptor = (PropertyDescriptorDTO)clientDto.getDescriptors().get(propertyDescriptor2.getName());
            PropertyDescriptorDtoMerger.merge(clientPropertyDescriptor, propertyDescriptorByNodeId);
        }
        Set<String> validationStatuses = dtoMap.values().stream().map(FlowAnalysisRuleDTO::getValidationStatus).collect(Collectors.toSet());
        clientDto.setValidationStatus(ErrorMerger.mergeValidationStatus(validationStatuses));
        clientDto.setValidationErrors(ErrorMerger.normalizedMergedErrors(validationErrorMap, dtoMap.size()));
    }
}

