/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.cluster.manager.PermissionsDtoMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.validation.RuleViolationKey;
import org.apache.nifi.web.api.dto.FlowAnalysisRuleViolationDTO;
import org.apache.nifi.web.api.entity.FlowAnalysisResultEntity;

public class FlowAnalysisResultEntityMerger {
    public void merge(FlowAnalysisResultEntity clientEntity, Map<NodeIdentifier, FlowAnalysisResultEntity> entityMap) {
        List aggregateRules = clientEntity.getRules();
        entityMap.values().stream().map(FlowAnalysisResultEntity::getRules).forEach(aggregateRules::addAll);
        Map<RuleViolationKey, FlowAnalysisRuleViolationDTO> mergedViolations = clientEntity.getRuleViolations().stream().collect(Collectors.toMap(violation -> new RuleViolationKey(violation.getScope(), violation.getSubjectId(), violation.getRuleId(), violation.getIssueId()), violation -> violation));
        for (Map.Entry<NodeIdentifier, FlowAnalysisResultEntity> entry : entityMap.entrySet()) {
            FlowAnalysisResultEntity entity = entry.getValue();
            entity.getRuleViolations().forEach(violation -> mergedViolations.compute(new RuleViolationKey(violation.getScope(), violation.getSubjectId(), violation.getRuleId(), violation.getIssueId()), (ruleViolationKey, storedViolation) -> {
                if (storedViolation != null) {
                    PermissionsDtoMerger.mergePermissions(violation.getSubjectPermissionDto(), storedViolation.getSubjectPermissionDto());
                }
                return violation;
            }));
        }
        List authorizedViolations = mergedViolations.values().stream().filter(violation -> violation.getSubjectPermissionDto().getCanRead()).collect(Collectors.toList());
        clientEntity.setRuleViolations(authorizedViolations);
    }
}

