/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.cluster.protocol.NodeIdentifier;

public final class ErrorMerger {
    private ErrorMerger() {
    }

    public static void mergeErrors(Map<String, Set<NodeIdentifier>> validationErrorMap, NodeIdentifier nodeId, Collection<String> nodeErrors) {
        if (nodeErrors != null) {
            nodeErrors.stream().forEach(err -> validationErrorMap.computeIfAbsent((String)err, k -> new HashSet()).add(nodeId));
        }
    }

    public static Set<String> normalizedMergedErrors(Map<String, Set<NodeIdentifier>> errorMap, int totalNodes) {
        HashSet<String> normalizedErrors = new HashSet<String>();
        for (Map.Entry<String, Set<NodeIdentifier>> validationEntry : errorMap.entrySet()) {
            String msg = validationEntry.getKey();
            Set<NodeIdentifier> nodeIds = validationEntry.getValue();
            if (nodeIds.size() == totalNodes) {
                normalizedErrors.add(msg);
                continue;
            }
            nodeIds.forEach(id -> normalizedErrors.add(id.getApiAddress() + ":" + id.getApiPort() + " -- " + msg));
        }
        return normalizedErrors;
    }

    public static <T> String mergeValidationStatus(Collection<String> validationStatuses) {
        boolean anyValidating = validationStatuses.stream().anyMatch(status -> "VALIDATING".equalsIgnoreCase((String)status));
        if (anyValidating) {
            return "VALIDATING";
        }
        boolean anyInvalid = validationStatuses.stream().anyMatch(status -> "INVALID".equalsIgnoreCase((String)status));
        if (anyInvalid) {
            return "INVALID";
        }
        return "VALID";
    }
}

