/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.replication;

import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.nifi.authorization.user.NiFiUser;

public class UploadRequest<T> {
    private final NiFiUser user;
    private final String filename;
    private final String identifier;
    private final InputStream contents;
    private final Map<String, String> headers;
    private final URI exampleRequestUri;
    private final Class<T> responseClass;
    private final int successfulResponseStatus;

    private UploadRequest(Builder<T> builder) {
        this.user = Objects.requireNonNull(builder.user);
        this.filename = Objects.requireNonNull(builder.filename);
        this.identifier = Objects.requireNonNull(builder.identifier);
        this.contents = Objects.requireNonNull(builder.contents);
        this.headers = Map.copyOf(builder.headers);
        this.exampleRequestUri = Objects.requireNonNull(builder.exampleRequestUri);
        this.responseClass = Objects.requireNonNull(builder.responseClass);
        this.successfulResponseStatus = builder.successfulResponseStatus;
        if (this.successfulResponseStatus <= 0) {
            throw new IllegalArgumentException("Successful response status must be greater than 0");
        }
    }

    public NiFiUser getUser() {
        return this.user;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public InputStream getContents() {
        return this.contents;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public URI getExampleRequestUri() {
        return this.exampleRequestUri;
    }

    public Class<T> getResponseClass() {
        return this.responseClass;
    }

    public int getSuccessfulResponseStatus() {
        return this.successfulResponseStatus;
    }

    public static final class Builder<T> {
        private NiFiUser user;
        private String filename;
        private String identifier;
        private InputStream contents;
        private URI exampleRequestUri;
        private Class<T> responseClass;
        private int successfulResponseStatus;
        private final Map<String, String> headers = new HashMap<String, String>();

        public Builder<T> user(NiFiUser user) {
            this.user = user;
            return this;
        }

        public Builder<T> filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder<T> identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder<T> contents(InputStream contents) {
            this.contents = contents;
            return this;
        }

        public Builder<T> exampleRequestUri(URI exampleRequestUri) {
            this.exampleRequestUri = exampleRequestUri;
            return this;
        }

        public Builder<T> responseClass(Class<T> responseClass) {
            this.responseClass = responseClass;
            return this;
        }

        public Builder<T> successfulResponseStatus(int successResponseStatus) {
            this.successfulResponseStatus = successResponseStatus;
            return this;
        }

        public Builder<T> header(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public UploadRequest<T> build() {
            return new UploadRequest(this);
        }
    }
}

