/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.replication;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.cluster.coordination.http.replication.AsyncClusterResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;

public class ResponseUtils {
    public static Set<NodeIdentifier> findLongResponseTimes(AsyncClusterResponse response, double stdDeviationMultiple) {
        HashSet<NodeIdentifier> slowResponses = new HashSet<NodeIdentifier>();
        if (response.isOlderThan(1L, TimeUnit.SECONDS)) {
            Set<NodeIdentifier> completedIds = response.getCompletedNodeIdentifiers();
            if (completedIds.size() < 2) {
                return slowResponses;
            }
            long requestMillisSum = 0L;
            int numNodes = 0;
            for (NodeIdentifier nodeId : completedIds) {
                long requestMillis = response.getNodeResponse(nodeId).getRequestDuration(TimeUnit.NANOSECONDS);
                if (requestMillis < 0L) continue;
                requestMillisSum += requestMillis;
                ++numNodes;
            }
            if (numNodes < 2) {
                return slowResponses;
            }
            double mean = requestMillisSum / (long)numNodes;
            double differenceSquaredSum = 0.0;
            for (NodeIdentifier nodeId : completedIds) {
                long requestMillis = response.getNodeResponse(nodeId).getRequestDuration(TimeUnit.NANOSECONDS);
                double differenceSquared = Math.pow(mean - (double)requestMillis, 2.0);
                differenceSquaredSum += differenceSquared;
            }
            double meanOfDifferenceSquared = differenceSquaredSum / (double)numNodes;
            double stdDev = Math.pow(meanOfDifferenceSquared, 0.5);
            double longTimeThreshold = mean + stdDev * stdDeviationMultiple;
            for (NodeIdentifier nodeId : completedIds) {
                long requestMillis = response.getNodeResponse(nodeId).getRequestDuration(TimeUnit.NANOSECONDS);
                if (!((double)requestMillis > longTimeThreshold)) continue;
                slowResponses.add(nodeId);
            }
        }
        return slowResponses;
    }
}

