/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.TenantsEntity;

public class SearchUsersEndpointMerger
implements EndpointResponseMerger {
    public static final Pattern SEARCH_TENANTS_URI_PATTERN = Pattern.compile("/nifi-api/tenants/search-results");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && SEARCH_TENANTS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    public final NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Mapper of type " + this.getClass().getSimpleName() + " to map responses for URI " + String.valueOf(uri) + ", HTTP Method " + method);
        }
        TenantsEntity responseEntity = (TenantsEntity)clientResponse.getClientResponse().readEntity(TenantsEntity.class);
        Collection userEntities = responseEntity.getUsers();
        Collection userGroupEntities = responseEntity.getUserGroups();
        for (NodeResponse nodeResponse : successfulResponses) {
            TenantsEntity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (TenantsEntity)nodeResponse.getClientResponse().readEntity(TenantsEntity.class);
            userEntities.retainAll(nodeResponseEntity.getUsers());
            userGroupEntities.retainAll(nodeResponseEntity.getUserGroups());
        }
        return new NodeResponse(clientResponse, (Entity)responseEntity);
    }
}

