/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.PermissionsDtoMerger;
import org.apache.nifi.controller.status.RunStatus;
import org.apache.nifi.web.api.dto.ProcessorRunStatusDetailsDTO;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.ProcessorRunStatusDetailsEntity;
import org.apache.nifi.web.api.entity.ProcessorsRunStatusDetailsEntity;

public class ProcessorRunStatusDetailsEndpointMerger
implements EndpointResponseMerger {
    public static final String RUN_STATUS_DETAILS_URI = "/nifi-api/processors/run-status-details/queries";

    @Override
    public boolean canHandle(URI uri, String method) {
        return "POST".equalsIgnoreCase(method) && RUN_STATUS_DETAILS_URI.equals(uri.getPath());
    }

    @Override
    public NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Mapper of type " + this.getClass().getSimpleName() + " to map responses for URI " + String.valueOf(uri) + ", HTTP Method " + method);
        }
        ProcessorsRunStatusDetailsEntity responseEntity = (ProcessorsRunStatusDetailsEntity)clientResponse.getClientResponse().readEntity(ProcessorsRunStatusDetailsEntity.class);
        Map<String, ProcessorRunStatusDetailsEntity> runStatusDetailMap = responseEntity.getRunStatusDetails().stream().collect(Collectors.toMap(entity -> entity.getRunStatusDetails().getId(), entity -> entity));
        for (NodeResponse nodeResponse : successfulResponses) {
            ProcessorsRunStatusDetailsEntity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (ProcessorsRunStatusDetailsEntity)nodeResponse.getClientResponse().readEntity(ProcessorsRunStatusDetailsEntity.class);
            for (ProcessorRunStatusDetailsEntity processorEntity : nodeResponseEntity.getRunStatusDetails()) {
                String processorId = processorEntity.getRunStatusDetails().getId();
                ProcessorRunStatusDetailsEntity mergedEntity = runStatusDetailMap.computeIfAbsent(processorId, id -> new ProcessorRunStatusDetailsEntity());
                this.merge(mergedEntity, processorEntity);
            }
        }
        ProcessorsRunStatusDetailsEntity mergedEntity = new ProcessorsRunStatusDetailsEntity();
        mergedEntity.setRunStatusDetails(new ArrayList<ProcessorRunStatusDetailsEntity>(runStatusDetailMap.values()));
        return new NodeResponse(clientResponse, (Entity)mergedEntity);
    }

    private void merge(ProcessorRunStatusDetailsEntity target, ProcessorRunStatusDetailsEntity additional) {
        PermissionsDtoMerger.mergePermissions(target.getPermissions(), additional.getPermissions());
        ProcessorRunStatusDetailsDTO targetRunStatusDetailsDto = target.getRunStatusDetails();
        ProcessorRunStatusDetailsDTO additionalRunStatusDetailsDto = additional.getRunStatusDetails();
        if (!additional.getPermissions().getCanRead().booleanValue()) {
            targetRunStatusDetailsDto.setName(null);
            targetRunStatusDetailsDto.setValidationErrors(null);
        }
        targetRunStatusDetailsDto.setActiveThreadCount(targetRunStatusDetailsDto.getActiveThreadCount() + additionalRunStatusDetailsDto.getActiveThreadCount());
        String additionalRunStatus = additionalRunStatusDetailsDto.getRunStatus();
        if (RunStatus.Invalid.name().equals(additionalRunStatus) || RunStatus.Validating.name().equals(additionalRunStatus)) {
            targetRunStatusDetailsDto.setRunStatus(additionalRunStatus);
        }
        Set additionalValidationErrors = additionalRunStatusDetailsDto.getValidationErrors();
        if (targetRunStatusDetailsDto.getValidationErrors() != null && additionalValidationErrors != null) {
            targetRunStatusDetailsDto.getValidationErrors().addAll(additionalValidationErrors);
        }
    }
}

