/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.ConnectionsEntityMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.ConnectionEntity;
import org.apache.nifi.web.api.entity.ConnectionsEntity;
import org.apache.nifi.web.api.entity.Entity;

public class ConnectionsEndpointMerger
implements EndpointResponseMerger {
    public static final Pattern CONNECTIONS_URI_PATTERN = Pattern.compile("/nifi-api/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/connections");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && CONNECTIONS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    public final NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Mapper of type " + this.getClass().getSimpleName() + " to map responses for URI " + String.valueOf(uri) + ", HTTP Method " + method);
        }
        ConnectionsEntity responseEntity = (ConnectionsEntity)clientResponse.getClientResponse().readEntity(ConnectionsEntity.class);
        Set connectionEntities = responseEntity.getConnections();
        HashMap<String, Map<NodeIdentifier, ConnectionEntity>> entityMap = new HashMap<String, Map<NodeIdentifier, ConnectionEntity>>();
        for (NodeResponse nodeResponse : successfulResponses) {
            ConnectionsEntity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (ConnectionsEntity)nodeResponse.getClientResponse().readEntity(ConnectionsEntity.class);
            Set nodeConnectionEntities = nodeResponseEntity.getConnections();
            for (ConnectionEntity nodeConnectionEntity : nodeConnectionEntities) {
                String nodeConnectionEntityId = nodeConnectionEntity.getId();
                HashMap<NodeIdentifier, ConnectionEntity> innerMap = (HashMap<NodeIdentifier, ConnectionEntity>)entityMap.get(nodeConnectionEntityId);
                if (innerMap == null) {
                    innerMap = new HashMap<NodeIdentifier, ConnectionEntity>();
                    entityMap.put(nodeConnectionEntityId, innerMap);
                }
                innerMap.put(nodeResponse.getNodeId(), nodeConnectionEntity);
            }
        }
        ConnectionsEntityMerger.mergeConnections(connectionEntities, entityMap);
        return new NodeResponse(clientResponse, (Entity)responseEntity);
    }
}

