/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow;

import org.apache.nifi.registry.authorization.Permissions;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.flow.FlowRegistryBucket;
import org.apache.nifi.registry.flow.FlowRegistryPermissions;
import org.apache.nifi.registry.flow.RegisteredFlow;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshot;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshotMetadata;
import org.apache.nifi.registry.flow.RegisteredFlowVersionInfo;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;
import org.apache.nifi.registry.revision.entity.RevisionInfo;

final class NifiRegistryUtil {
    NifiRegistryUtil() {
    }

    static FlowRegistryBucket convert(Bucket bucket) {
        FlowRegistryBucket result = new FlowRegistryBucket();
        result.setIdentifier(bucket.getIdentifier());
        result.setName(bucket.getName());
        result.setDescription(bucket.getDescription());
        result.setCreatedTimestamp(bucket.getCreatedTimestamp());
        result.setPermissions(NifiRegistryUtil.convert(bucket.getPermissions()));
        return result;
    }

    static Bucket convert(FlowRegistryBucket bucket) {
        if (bucket == null) {
            return null;
        }
        Bucket result = new Bucket();
        result.setIdentifier(bucket.getIdentifier());
        result.setName(bucket.getName());
        result.setDescription(bucket.getDescription());
        result.setCreatedTimestamp(bucket.getCreatedTimestamp());
        result.setPermissions(NifiRegistryUtil.convert(bucket.getPermissions()));
        return result;
    }

    static FlowRegistryPermissions convert(Permissions permissions) {
        if (permissions == null) {
            return null;
        }
        FlowRegistryPermissions result = new FlowRegistryPermissions();
        result.setCanRead(permissions.getCanRead());
        result.setCanWrite(permissions.getCanWrite());
        result.setCanDelete(permissions.getCanDelete());
        return result;
    }

    static Permissions convert(FlowRegistryPermissions permissions) {
        if (permissions == null) {
            return null;
        }
        Permissions result = new Permissions();
        result.setCanRead(permissions.getCanRead());
        result.setCanWrite(permissions.getCanWrite());
        result.setCanDelete(permissions.getCanDelete());
        return result;
    }

    static RegisteredFlowSnapshotMetadata convert(VersionedFlowSnapshotMetadata metadata) {
        RegisteredFlowSnapshotMetadata result = new RegisteredFlowSnapshotMetadata();
        result.setBucketIdentifier(metadata.getBucketIdentifier());
        result.setFlowIdentifier(metadata.getFlowIdentifier());
        result.setVersion(String.valueOf(metadata.getVersion()));
        result.setTimestamp(metadata.getTimestamp());
        result.setAuthor(metadata.getAuthor());
        result.setComments(metadata.getComments());
        return result;
    }

    static VersionedFlowSnapshotMetadata convert(RegisteredFlowSnapshotMetadata metadata) {
        VersionedFlowSnapshotMetadata result = new VersionedFlowSnapshotMetadata();
        result.setBucketIdentifier(metadata.getBucketIdentifier());
        result.setFlowIdentifier(metadata.getFlowIdentifier());
        result.setVersion(Integer.parseInt(metadata.getVersion()));
        result.setTimestamp(metadata.getTimestamp());
        result.setAuthor(metadata.getAuthor());
        result.setComments(metadata.getComments());
        return result;
    }

    static RegisteredFlowVersionInfo convert(RevisionInfo revisionInfo) {
        if (revisionInfo == null) {
            return null;
        }
        RegisteredFlowVersionInfo result = new RegisteredFlowVersionInfo();
        result.setVersion(revisionInfo.getVersion().longValue());
        return result;
    }

    static RevisionInfo convert(RegisteredFlowVersionInfo versionInfo) {
        if (versionInfo == null) {
            return null;
        }
        RevisionInfo result = new RevisionInfo();
        result.setVersion(Long.valueOf(versionInfo.getVersion()));
        return result;
    }

    static RegisteredFlow convert(VersionedFlow flow) {
        RegisteredFlow result = new RegisteredFlow();
        result.setIdentifier(flow.getIdentifier());
        result.setName(flow.getName());
        result.setDescription(flow.getDescription());
        result.setBucketIdentifier(flow.getBucketIdentifier());
        result.setBucketName(flow.getBucketName());
        result.setCreatedTimestamp(flow.getCreatedTimestamp());
        result.setLastModifiedTimestamp(flow.getModifiedTimestamp());
        result.setPermissions(NifiRegistryUtil.convert(flow.getPermissions()));
        result.setVersionCount(flow.getVersionCount());
        result.setVersionInfo(NifiRegistryUtil.convert(flow.getRevision()));
        return result;
    }

    static VersionedFlow convert(RegisteredFlow flow) {
        if (flow == null) {
            return null;
        }
        VersionedFlow result = new VersionedFlow();
        result.setIdentifier(flow.getIdentifier());
        result.setName(flow.getName());
        result.setDescription(flow.getDescription());
        result.setBucketIdentifier(flow.getBucketIdentifier());
        result.setBucketName(flow.getBucketName());
        result.setCreatedTimestamp(flow.getCreatedTimestamp());
        result.setModifiedTimestamp(flow.getLastModifiedTimestamp());
        result.setPermissions(NifiRegistryUtil.convert(flow.getPermissions()));
        result.setVersionCount(flow.getVersionCount());
        result.setRevision(NifiRegistryUtil.convert(flow.getVersionInfo()));
        return result;
    }

    static RegisteredFlowSnapshot convert(VersionedFlowSnapshot flowSnapshot) {
        RegisteredFlowSnapshot result = new RegisteredFlowSnapshot();
        result.setSnapshotMetadata(NifiRegistryUtil.convert(flowSnapshot.getSnapshotMetadata()));
        result.setFlow(NifiRegistryUtil.convert(flowSnapshot.getFlow()));
        result.setBucket(NifiRegistryUtil.convert(flowSnapshot.getBucket()));
        result.setFlowContents(flowSnapshot.getFlowContents());
        result.setExternalControllerServices(flowSnapshot.getExternalControllerServices());
        result.setParameterContexts(flowSnapshot.getParameterContexts());
        result.setFlowEncodingVersion(flowSnapshot.getFlowEncodingVersion());
        result.setParameterProviders(flowSnapshot.getParameterProviders());
        return result;
    }

    static VersionedFlowSnapshot convert(RegisteredFlowSnapshot flowSnapshot) {
        VersionedFlowSnapshot result = new VersionedFlowSnapshot();
        result.setSnapshotMetadata(NifiRegistryUtil.convert(flowSnapshot.getSnapshotMetadata()));
        result.setFlow(NifiRegistryUtil.convert(flowSnapshot.getFlow()));
        result.setBucket(NifiRegistryUtil.convert(flowSnapshot.getBucket()));
        result.setFlowContents(flowSnapshot.getFlowContents());
        result.setExternalControllerServices(flowSnapshot.getExternalControllerServices());
        result.setParameterContexts(flowSnapshot.getParameterContexts());
        result.setFlowEncodingVersion(flowSnapshot.getFlowEncodingVersion());
        result.setParameterProviders(flowSnapshot.getParameterProviders());
        return result;
    }
}

