/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.AccessPolicyMapper;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.parsers.StandardDocumentProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class FingerprintAccessPolicyMapper
implements AccessPolicyMapper {
    private static final String ACCESS_POLICIES = "accessPolicies";
    private static final String POLICY = "policy";
    private static final String POLICY_USER = "policyUser";
    private static final String POLICY_GROUP = "policyGroup";
    private static final String IDENTIFIER = "identifier";
    private static final String RESOURCE = "resource";
    private static final String ACTIONS = "actions";

    FingerprintAccessPolicyMapper() {
    }

    @Override
    public List<AccessPolicy> readAccessPolicies(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "Input Stream required");
        StandardDocumentProvider documentProvider = new StandardDocumentProvider();
        Document document = documentProvider.parse(inputStream);
        ArrayList<AccessPolicy> accessPolicies = new ArrayList<AccessPolicy>();
        Element rootElement = document.getDocumentElement();
        NodeList policyNodes = rootElement.getElementsByTagName(POLICY);
        for (int i = 0; i < policyNodes.getLength(); ++i) {
            Element policy = (Element)policyNodes.item(i);
            AccessPolicy accessPolicy = this.readAccessPolicy(policy);
            accessPolicies.add(accessPolicy);
        }
        return accessPolicies;
    }

    @Override
    public void writeAccessPolicies(List<AccessPolicy> accessPolicies, OutputStream outputStream) {
        Objects.requireNonNull(accessPolicies, "Access Policies required");
        Objects.requireNonNull(outputStream, "Output Stream required");
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter streamWriter = null;
        try {
            streamWriter = outputFactory.createXMLStreamWriter(outputStream);
            streamWriter.writeStartDocument();
            streamWriter.writeStartElement(ACCESS_POLICIES);
            accessPolicies.sort(Comparator.comparing(AccessPolicy::getIdentifier));
            for (AccessPolicy accessPolicy : accessPolicies) {
                this.writePolicy(streamWriter, accessPolicy);
            }
            streamWriter.writeEndElement();
            streamWriter.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new ProcessingException("Writing Access Policies failed", (Throwable)e);
        }
        finally {
            if (streamWriter != null) {
                try {
                    streamWriter.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
    }

    private AccessPolicy readAccessPolicy(Element policy) {
        RequestAction requestAction;
        String identifier = policy.getAttribute(IDENTIFIER);
        String resource = policy.getAttribute(RESOURCE);
        String actions = policy.getAttribute(ACTIONS);
        if (RequestAction.READ.name().equals(actions)) {
            requestAction = RequestAction.READ;
        } else if (RequestAction.WRITE.name().equals(actions)) {
            requestAction = RequestAction.WRITE;
        } else {
            throw new IllegalStateException("Unknown Policy Action [%s]".formatted(actions));
        }
        AccessPolicy.Builder builder = new AccessPolicy.Builder().identifier(identifier).resource(resource).action(requestAction);
        NodeList users = policy.getElementsByTagName(POLICY_USER);
        for (int i = 0; i < users.getLength(); ++i) {
            Element user = (Element)users.item(i);
            String userIdentifier = user.getAttribute(IDENTIFIER);
            builder.addUser(userIdentifier);
        }
        NodeList groups = policy.getElementsByTagName(POLICY_GROUP);
        for (int i = 0; i < groups.getLength(); ++i) {
            Element group = (Element)groups.item(i);
            String groupIdentifier = group.getAttribute(IDENTIFIER);
            builder.addGroup(groupIdentifier);
        }
        return builder.build();
    }

    private void writePolicy(XMLStreamWriter writer, AccessPolicy accessPolicy) throws XMLStreamException {
        String action;
        ArrayList users = new ArrayList(accessPolicy.getUsers());
        Collections.sort(users);
        ArrayList groups = new ArrayList(accessPolicy.getGroups());
        Collections.sort(groups);
        writer.writeStartElement(POLICY);
        writer.writeAttribute(IDENTIFIER, accessPolicy.getIdentifier());
        writer.writeAttribute(RESOURCE, accessPolicy.getResource());
        RequestAction requestAction = accessPolicy.getAction();
        if (RequestAction.READ == requestAction) {
            action = requestAction.name();
        } else if (RequestAction.WRITE == requestAction) {
            action = requestAction.name();
        } else {
            throw new IllegalStateException("Request Action [%s] not supported".formatted(requestAction));
        }
        writer.writeAttribute(ACTIONS, action);
        for (String user : users) {
            writer.writeStartElement(POLICY_USER);
            writer.writeAttribute(IDENTIFIER, user);
            writer.writeEndElement();
        }
        for (String group : groups) {
            writer.writeStartElement(POLICY_GROUP);
            writer.writeAttribute(IDENTIFIER, group);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

