/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.AccessPolicyMapper;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.parsers.StandardDocumentProvider;
import org.apache.nifi.xml.processing.transform.StandardTransformProvider;
import org.apache.nifi.xml.processing.validation.StandardSchemaValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class FileAccessPolicyMapper
implements AccessPolicyMapper {
    static final String READ = "R";
    static final String WRITE = "W";
    private static final String AUTHORIZATIONS_XSD = "/authorizations.xsd";
    private static final String AUTHORIZATIONS = "authorizations";
    private static final String POLICIES = "policies";
    private static final String POLICY = "policy";
    private static final String USER = "user";
    private static final String GROUP = "group";
    private static final String IDENTIFIER = "identifier";
    private static final String RESOURCE = "resource";
    private static final String ACTION = "action";

    FileAccessPolicyMapper() {
    }

    @Override
    public List<AccessPolicy> readAccessPolicies(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "Input Stream required");
        StandardSchemaValidator schemaValidator = new StandardSchemaValidator();
        Schema schema = this.getSchema();
        StandardDocumentProvider documentProvider = new StandardDocumentProvider();
        Document document = documentProvider.parse(inputStream);
        DOMSource source = new DOMSource(document);
        schemaValidator.validate(schema, (Source)source);
        ArrayList<AccessPolicy> accessPolicies = new ArrayList<AccessPolicy>();
        Element rootElement = document.getDocumentElement();
        NodeList policyNodes = rootElement.getElementsByTagName(POLICY);
        for (int i = 0; i < policyNodes.getLength(); ++i) {
            Element policy = (Element)policyNodes.item(i);
            AccessPolicy accessPolicy = this.readAccessPolicy(policy);
            accessPolicies.add(accessPolicy);
        }
        return accessPolicies;
    }

    @Override
    public void writeAccessPolicies(List<AccessPolicy> accessPolicies, OutputStream outputStream) {
        Objects.requireNonNull(accessPolicies, "Access Policies required");
        Objects.requireNonNull(outputStream, "Output Stream required");
        StandardDocumentProvider documentProvider = new StandardDocumentProvider();
        Document document = documentProvider.newDocument();
        Element authorizations = document.createElement(AUTHORIZATIONS);
        document.appendChild(authorizations);
        Element policies = document.createElement(POLICIES);
        authorizations.appendChild(policies);
        for (AccessPolicy accessPolicy : accessPolicies) {
            Element policy = this.writePolicy(document, accessPolicy);
            policies.appendChild(policy);
        }
        StandardTransformProvider transformProvider = new StandardTransformProvider();
        transformProvider.setIndent(true);
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(outputStream);
        transformProvider.transform((Source)source, (Result)result);
    }

    private AccessPolicy readAccessPolicy(Element policy) {
        RequestAction requestAction;
        String identifier = policy.getAttribute(IDENTIFIER);
        String resource = policy.getAttribute(RESOURCE);
        String action = policy.getAttribute(ACTION);
        if (READ.equals(action)) {
            requestAction = RequestAction.READ;
        } else if (WRITE.equals(action)) {
            requestAction = RequestAction.WRITE;
        } else {
            throw new IllegalStateException("Unknown Policy Action [%s]".formatted(action));
        }
        AccessPolicy.Builder builder = new AccessPolicy.Builder().identifier(identifier).resource(resource).action(requestAction);
        NodeList users = policy.getElementsByTagName(USER);
        for (int i = 0; i < users.getLength(); ++i) {
            Element user = (Element)users.item(i);
            String userIdentifier = user.getAttribute(IDENTIFIER);
            builder.addUser(userIdentifier);
        }
        NodeList groups = policy.getElementsByTagName(GROUP);
        for (int i = 0; i < groups.getLength(); ++i) {
            Element group = (Element)groups.item(i);
            String groupIdentifier = group.getAttribute(IDENTIFIER);
            builder.addGroup(groupIdentifier);
        }
        return builder.build();
    }

    private Element writePolicy(Document document, AccessPolicy accessPolicy) {
        String action;
        ArrayList users = new ArrayList(accessPolicy.getUsers());
        Collections.sort(users);
        ArrayList groups = new ArrayList(accessPolicy.getGroups());
        Collections.sort(groups);
        Element policy = document.createElement(POLICY);
        policy.setAttribute(IDENTIFIER, accessPolicy.getIdentifier());
        policy.setAttribute(RESOURCE, accessPolicy.getResource());
        RequestAction requestAction = accessPolicy.getAction();
        if (RequestAction.READ == requestAction) {
            action = READ;
        } else if (RequestAction.WRITE == requestAction) {
            action = WRITE;
        } else {
            throw new IllegalStateException("Request Action [%s] not supported".formatted(requestAction));
        }
        policy.setAttribute(ACTION, action);
        for (String group : groups) {
            Element policyGroup = document.createElement(GROUP);
            policyGroup.setAttribute(IDENTIFIER, group);
            policy.appendChild(policyGroup);
        }
        for (String user : users) {
            Element policyUser = document.createElement(USER);
            policyUser.setAttribute(IDENTIFIER, user);
            policy.appendChild(policyUser);
        }
        return policy;
    }

    private Schema getSchema() {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            return schemaFactory.newSchema(this.getClass().getResource(AUTHORIZATIONS_XSD));
        }
        catch (SAXException e) {
            throw new ProcessingException("Failed to read Authorizations Schema", (Throwable)e);
        }
    }
}

