/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.nifi.authorization.AuthorizedUserGroups;
import org.apache.nifi.authorization.AuthorizedUserGroupsMapper;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.xml.processing.parsers.StandardDocumentProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class FingerprintAuthorizedUserGroupsMapper
implements AuthorizedUserGroupsMapper {
    private static final String TENANTS = "tenants";
    private static final String USER = "user";
    private static final String GROUP_USER = "groupUser";
    private static final String GROUP = "group";
    private static final String IDENTIFIER = "identifier";
    private static final String IDENTITY = "identity";
    private static final String NAME = "name";

    FingerprintAuthorizedUserGroupsMapper() {
    }

    @Override
    public AuthorizedUserGroups readUserGroups(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "Input Stream required");
        StandardDocumentProvider documentProvider = new StandardDocumentProvider();
        Document document = documentProvider.parse(inputStream);
        NodeList tenantsFound = document.getElementsByTagName(TENANTS);
        Element tenants = (Element)tenantsFound.item(0);
        ArrayList<User> users = new ArrayList<User>();
        ArrayList<Group> groups = new ArrayList<Group>();
        NodeList userNodes = tenants.getElementsByTagName(USER);
        for (int i = 0; i < userNodes.getLength(); ++i) {
            Element userNode = (Element)userNodes.item(i);
            String identifier = userNode.getAttribute(IDENTIFIER);
            String identity = userNode.getAttribute(IDENTITY);
            User user = new User.Builder().identifier(identifier).identity(identity).build();
            users.add(user);
        }
        NodeList groupNodes = tenants.getElementsByTagName(GROUP);
        for (int i = 0; i < groupNodes.getLength(); ++i) {
            Element groupNode = (Element)groupNodes.item(i);
            String identifier = groupNode.getAttribute(IDENTIFIER);
            String name = groupNode.getAttribute(NAME);
            HashSet<String> groupUsers = new HashSet<String>();
            NodeList groupUserNodes = groupNode.getElementsByTagName(GROUP_USER);
            for (int j = 0; j < groupUserNodes.getLength(); ++j) {
                Element groupUserNode = (Element)groupUserNodes.item(j);
                String groupUserIdentifier = groupUserNode.getAttribute(IDENTIFIER);
                groupUsers.add(groupUserIdentifier);
            }
            Group group = new Group.Builder().identifier(identifier).name(name).addUsers(groupUsers).build();
            groups.add(group);
        }
        return new AuthorizedUserGroups(users, groups);
    }

    @Override
    public void writeUserGroups(AuthorizedUserGroups userGroups, OutputStream outputStream) {
        Objects.requireNonNull(userGroups, "User Groups required");
        Objects.requireNonNull(outputStream, "Output Stream required");
        List<User> users = userGroups.users();
        users.sort(Comparator.comparing(User::getIdentifier));
        List<Group> groups = userGroups.groups();
        groups.sort(Comparator.comparing(Group::getIdentifier));
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = null;
        try {
            writer = outputFactory.createXMLStreamWriter(outputStream);
            writer.writeStartDocument();
            writer.writeStartElement(TENANTS);
            for (User user : users) {
                writer.writeStartElement(USER);
                writer.writeAttribute(IDENTIFIER, user.getIdentifier());
                writer.writeAttribute(IDENTITY, user.getIdentity());
                writer.writeEndElement();
            }
            for (Group group : groups) {
                this.writeGroup(writer, group);
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new AuthorizationAccessException("User Groups Fingerprint generation failed", (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
    }

    private void writeGroup(XMLStreamWriter writer, Group group) throws XMLStreamException {
        ArrayList users = new ArrayList(group.getUsers());
        Collections.sort(users);
        writer.writeStartElement(GROUP);
        writer.writeAttribute(IDENTIFIER, group.getIdentifier());
        writer.writeAttribute(NAME, group.getName());
        for (String user : users) {
            writer.writeStartElement(GROUP_USER);
            writer.writeAttribute(IDENTIFIER, user);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

