/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.authorization.ConfigurableUserGroupProvider;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.UserAndGroups;
import org.apache.nifi.authorization.UserGroupHolder;
import org.apache.nifi.authorization.UserGroupProviderInitializationContext;
import org.apache.nifi.authorization.annotation.AuthorizerContext;
import org.apache.nifi.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.authorization.exception.AuthorizerCreationException;
import org.apache.nifi.authorization.exception.AuthorizerDestructionException;
import org.apache.nifi.authorization.exception.UninheritableAuthorizationsException;
import org.apache.nifi.authorization.file.tenants.generated.Group;
import org.apache.nifi.authorization.file.tenants.generated.Groups;
import org.apache.nifi.authorization.file.tenants.generated.Tenants;
import org.apache.nifi.authorization.file.tenants.generated.Users;
import org.apache.nifi.authorization.util.IdentityMappingUtil;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.file.FileUtils;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.parsers.StandardDocumentProvider;
import org.apache.nifi.xml.processing.stream.StandardXMLStreamReaderProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileUserGroupProvider
implements ConfigurableUserGroupProvider {
    private static final Logger logger = LoggerFactory.getLogger(FileUserGroupProvider.class);
    private static final String TENANTS_XSD = "/tenants.xsd";
    private static final String JAXB_TENANTS_PATH = "org.apache.nifi.authorization.file.tenants.generated";
    private static final JAXBContext JAXB_TENANTS_CONTEXT = FileUserGroupProvider.initializeJaxbContext();
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private static final String USER_ELEMENT = "user";
    private static final String GROUP_USER_ELEMENT = "groupUser";
    private static final String GROUP_ELEMENT = "group";
    private static final String IDENTIFIER_ATTR = "identifier";
    private static final String IDENTITY_ATTR = "identity";
    private static final String NAME_ATTR = "name";
    static final String PROP_TENANTS_FILE = "Users File";
    static final String PROP_INITIAL_USER_IDENTITY_PREFIX = "Initial User Identity ";
    static final Pattern INITIAL_USER_IDENTITY_PATTERN = Pattern.compile("Initial User Identity \\S+");
    static final String PROP_INITIAL_GROUP_IDENTITY_PREFIX = "Initial Group Identity ";
    static final Pattern INITIAL_GROUP_IDENTITY_PATTERN = Pattern.compile("Initial Group Identity \\S+");
    private Schema tenantsSchema;
    private NiFiProperties properties;
    private File tenantsFile;
    private File restoreTenantsFile;
    private Set<String> initialUserIdentities;
    private Set<String> initialGroupIdentities;
    private final AtomicReference<UserGroupHolder> userGroupHolder = new AtomicReference();

    private static JAXBContext initializeJaxbContext() {
        try {
            return JAXBContext.newInstance((String)JAXB_TENANTS_PATH, (ClassLoader)FileUserGroupProvider.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to create JAXBContext.", e);
        }
    }

    public void initialize(UserGroupProviderInitializationContext initializationContext) throws AuthorizerCreationException {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.tenantsSchema = schemaFactory.newSchema(FileUserGroupProvider.class.getResource(TENANTS_XSD));
        }
        catch (Exception e) {
            throw new AuthorizerCreationException((Throwable)e);
        }
    }

    public void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
        try {
            PropertyValue tenantsPath = configurationContext.getProperty(PROP_TENANTS_FILE);
            if (StringUtils.isBlank((CharSequence)tenantsPath.getValue())) {
                throw new AuthorizerCreationException("The users file must be specified.");
            }
            this.tenantsFile = new File(tenantsPath.getValue());
            if (!this.tenantsFile.exists()) {
                logger.info("Creating new users file at {}", (Object)this.tenantsFile.getAbsolutePath());
                this.saveTenants(new Tenants());
            }
            File tenantsFileDirectory = this.tenantsFile.getAbsoluteFile().getParentFile();
            File restoreDirectory = this.properties.getRestoreDirectory();
            if (restoreDirectory != null) {
                FileUtils.ensureDirectoryExistAndCanAccess((File)restoreDirectory);
                if (tenantsFileDirectory.getAbsolutePath().equals(restoreDirectory.getAbsolutePath())) {
                    throw new AuthorizerCreationException(String.format("Users file directory '%s' is the same as restore directory '%s' ", tenantsFileDirectory.getAbsolutePath(), restoreDirectory.getAbsolutePath()));
                }
                this.restoreTenantsFile = new File(restoreDirectory, this.tenantsFile.getName());
                try {
                    FileUtils.syncWithRestore((File)this.tenantsFile, (File)this.restoreTenantsFile, (Logger)logger);
                }
                catch (IOException | IllegalStateException ioe) {
                    throw new AuthorizerCreationException((Throwable)ioe);
                }
            }
            List identityMappings = Collections.unmodifiableList(IdentityMappingUtil.getIdentityMappings((NiFiProperties)this.properties));
            this.initialUserIdentities = new HashSet<String>();
            this.initialGroupIdentities = new HashSet<String>();
            for (Map.Entry entry : configurationContext.getProperties().entrySet()) {
                if (INITIAL_USER_IDENTITY_PATTERN.matcher((CharSequence)entry.getKey()).matches()) {
                    if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
                    this.initialUserIdentities.add(IdentityMappingUtil.mapIdentity((String)((String)entry.getValue()), identityMappings));
                    continue;
                }
                if (!INITIAL_GROUP_IDENTITY_PATTERN.matcher((CharSequence)entry.getKey()).matches() || !StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
                this.initialGroupIdentities.add(IdentityMappingUtil.mapIdentity((String)((String)entry.getValue()), identityMappings));
            }
            this.load();
            if (this.restoreTenantsFile != null) {
                FileUtils.copyFile((File)this.tenantsFile, (File)this.restoreTenantsFile, (boolean)false, (boolean)false, (Logger)logger);
            }
            logger.debug("Users/Groups file loaded");
        }
        catch (JAXBException | IOException | IllegalStateException | AuthorizerCreationException e) {
            throw new AuthorizerCreationException(e);
        }
    }

    public Set<User> getUsers() throws AuthorizationAccessException {
        return this.userGroupHolder.get().getAllUsers();
    }

    public synchronized User addUser(User user) throws AuthorizationAccessException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        UsersAndGroups usersAndGroups = new UsersAndGroups(Collections.singletonList(user), Collections.emptyList());
        this.addUsersAndGroups(usersAndGroups);
        return this.userGroupHolder.get().getUsersById().get(user.getIdentifier());
    }

    public User getUser(String identifier) throws AuthorizationAccessException {
        if (identifier == null) {
            return null;
        }
        UserGroupHolder holder = this.userGroupHolder.get();
        return holder.getUsersById().get(identifier);
    }

    public synchronized User updateUser(User user) throws AuthorizationAccessException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        UserGroupHolder holder = this.userGroupHolder.get();
        Tenants tenants = holder.getTenants();
        List<org.apache.nifi.authorization.file.tenants.generated.User> users = tenants.getUsers().getUser();
        org.apache.nifi.authorization.file.tenants.generated.User updateUser = null;
        for (org.apache.nifi.authorization.file.tenants.generated.User jaxbUser : users) {
            if (!user.getIdentifier().equals(jaxbUser.getIdentifier())) continue;
            updateUser = jaxbUser;
            break;
        }
        if (updateUser == null) {
            return null;
        }
        updateUser.setIdentity(user.getIdentity());
        this.saveAndRefreshHolder(tenants);
        return this.userGroupHolder.get().getUsersById().get(user.getIdentifier());
    }

    public User getUserByIdentity(String identity) throws AuthorizationAccessException {
        if (identity == null) {
            return null;
        }
        UserGroupHolder holder = this.userGroupHolder.get();
        return holder.getUsersByIdentity().get(identity);
    }

    public synchronized User deleteUser(User user) throws AuthorizationAccessException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        UserGroupHolder holder = this.userGroupHolder.get();
        Tenants tenants = holder.getTenants();
        List<org.apache.nifi.authorization.file.tenants.generated.User> users = tenants.getUsers().getUser();
        block0: for (Group group : tenants.getGroups().getGroup()) {
            Iterator<Group.User> groupUserIter = group.getUser().iterator();
            while (groupUserIter.hasNext()) {
                Group.User groupUser = groupUserIter.next();
                if (!groupUser.getIdentifier().equals(user.getIdentifier())) continue;
                groupUserIter.remove();
                continue block0;
            }
        }
        boolean removedUser = false;
        Iterator<org.apache.nifi.authorization.file.tenants.generated.User> iter = users.iterator();
        while (iter.hasNext()) {
            org.apache.nifi.authorization.file.tenants.generated.User jaxbUser = iter.next();
            if (!user.getIdentifier().equals(jaxbUser.getIdentifier())) continue;
            iter.remove();
            removedUser = true;
            break;
        }
        if (removedUser) {
            this.saveAndRefreshHolder(tenants);
            return user;
        }
        return null;
    }

    public Set<org.apache.nifi.authorization.Group> getGroups() throws AuthorizationAccessException {
        return this.userGroupHolder.get().getAllGroups();
    }

    private synchronized void addUsersAndGroups(UsersAndGroups usersAndGroups) {
        UserGroupHolder holder = this.userGroupHolder.get();
        Tenants tenants = holder.getTenants();
        List<org.apache.nifi.authorization.Group> groups = usersAndGroups.getGroups();
        for (org.apache.nifi.authorization.Group group : groups) {
            Group jaxbGroup = new Group();
            jaxbGroup.setIdentifier(group.getIdentifier());
            jaxbGroup.setName(group.getName());
            for (String groupUser : group.getUsers()) {
                Group.User jaxbGroupUser = new Group.User();
                jaxbGroupUser.setIdentifier(groupUser);
                jaxbGroup.getUser().add(jaxbGroupUser);
            }
            tenants.getGroups().getGroup().add(jaxbGroup);
        }
        List<User> users = usersAndGroups.getUsers();
        for (User user : users) {
            org.apache.nifi.authorization.file.tenants.generated.User jaxbUser = this.createJAXBUser(user);
            tenants.getUsers().getUser().add(jaxbUser);
        }
        this.saveAndRefreshHolder(tenants);
    }

    public synchronized org.apache.nifi.authorization.Group addGroup(org.apache.nifi.authorization.Group group) throws AuthorizationAccessException {
        if (group == null) {
            throw new IllegalArgumentException("Group cannot be null");
        }
        UsersAndGroups usersAndGroups = new UsersAndGroups(Collections.emptyList(), Collections.singletonList(group));
        this.addUsersAndGroups(usersAndGroups);
        return this.userGroupHolder.get().getGroupsById().get(group.getIdentifier());
    }

    public org.apache.nifi.authorization.Group getGroup(String identifier) throws AuthorizationAccessException {
        if (identifier == null) {
            return null;
        }
        return this.userGroupHolder.get().getGroupsById().get(identifier);
    }

    public org.apache.nifi.authorization.Group getGroupByName(String name) throws AuthorizationAccessException {
        if (name == null) {
            return null;
        }
        return this.userGroupHolder.get().getGroupsByName().get(name);
    }

    public UserAndGroups getUserAndGroups(String identity) throws AuthorizationAccessException {
        UserGroupHolder holder = this.userGroupHolder.get();
        final User user = holder.getUser(identity);
        final Set<org.apache.nifi.authorization.Group> groups = holder.getGroups(identity);
        return new UserAndGroups(){

            public User getUser() {
                return user;
            }

            public Set<org.apache.nifi.authorization.Group> getGroups() {
                return groups;
            }
        };
    }

    public synchronized org.apache.nifi.authorization.Group updateGroup(org.apache.nifi.authorization.Group group) throws AuthorizationAccessException {
        if (group == null) {
            throw new IllegalArgumentException("Group cannot be null");
        }
        UserGroupHolder holder = this.userGroupHolder.get();
        Tenants tenants = holder.getTenants();
        Group updateGroup = null;
        for (Group jaxbGroup : tenants.getGroups().getGroup()) {
            if (!jaxbGroup.getIdentifier().equals(group.getIdentifier())) continue;
            updateGroup = jaxbGroup;
            break;
        }
        if (updateGroup == null) {
            return null;
        }
        updateGroup.getUser().clear();
        for (String groupUser : group.getUsers()) {
            Group.User jaxbGroupUser = new Group.User();
            jaxbGroupUser.setIdentifier(groupUser);
            updateGroup.getUser().add(jaxbGroupUser);
        }
        updateGroup.setName(group.getName());
        this.saveAndRefreshHolder(tenants);
        return this.userGroupHolder.get().getGroupsById().get(group.getIdentifier());
    }

    public synchronized org.apache.nifi.authorization.Group deleteGroup(org.apache.nifi.authorization.Group group) throws AuthorizationAccessException {
        UserGroupHolder holder = this.userGroupHolder.get();
        Tenants tenants = holder.getTenants();
        List<Group> groups = tenants.getGroups().getGroup();
        boolean removedGroup = false;
        Iterator<Group> iter = groups.iterator();
        while (iter.hasNext()) {
            Group jaxbGroup = iter.next();
            if (!group.getIdentifier().equals(jaxbGroup.getIdentifier())) continue;
            iter.remove();
            removedGroup = true;
            break;
        }
        if (removedGroup) {
            this.saveAndRefreshHolder(tenants);
            return group;
        }
        return null;
    }

    UserGroupHolder getUserGroupHolder() {
        return this.userGroupHolder.get();
    }

    @AuthorizerContext
    public void setNiFiProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public synchronized void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
        UsersAndGroups usersAndGroups = this.parseUsersAndGroups(fingerprint);
        this.inherit(usersAndGroups);
    }

    private synchronized void inherit(UsersAndGroups usersAndGroups) {
        this.addUsersAndGroups(usersAndGroups);
    }

    public synchronized void forciblyInheritFingerprint(String fingerprint) throws AuthorizationAccessException {
        if (fingerprint == null || fingerprint.trim().isEmpty()) {
            logger.info("Inheriting Empty Users & Groups. Will backup existing Uesrs & Groups first.");
            this.backupUsersAndGroups();
            this.purgeUsersAndGroups();
            return;
        }
        UsersAndGroups usersAndGroups = this.parseUsersAndGroups(fingerprint);
        if (this.isInheritable()) {
            logger.debug("Inheriting cluster's Users & Groups");
            this.inherit(usersAndGroups);
        } else {
            logger.info("Cannot directly inherit proposed Users & Groups so will backup existing Users & Groups and then replace with proposed configuration");
            this.backupUsersAndGroups();
            this.purgeUsersAndGroups();
            this.addUsersAndGroups(usersAndGroups);
        }
    }

    public void backupUsersAndGroups() throws AuthorizationAccessException {
        UserGroupHolder holder = this.userGroupHolder.get();
        Tenants tenants = holder.getTenants();
        String timestamp = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss").format(OffsetDateTime.now());
        File destinationFile = new File(this.tenantsFile.getParentFile(), this.tenantsFile.getName() + "." + timestamp);
        logger.info("Writing backup of Users & Groups to {}", (Object)destinationFile.getAbsolutePath());
        try {
            this.saveTenants(tenants, destinationFile);
        }
        catch (JAXBException jaxb) {
            throw new AuthorizationAccessException("Could not backup existing Users and Groups so will not inherit new Users and Groups", (Throwable)jaxb);
        }
    }

    public synchronized void purgeUsersAndGroups() {
        UserGroupHolder holder = this.userGroupHolder.get();
        Tenants tenants = holder.getTenants();
        tenants.setGroups(new Groups());
        tenants.setUsers(new Users());
        this.saveAndRefreshHolder(tenants);
    }

    public void checkInheritability(String proposedFingerprint) throws AuthorizationAccessException {
        if (!this.isInheritable()) {
            throw new UninheritableAuthorizationsException("Proposed fingerprint is not inheritable because the current users and groups is not empty.");
        }
    }

    private boolean isInheritable() {
        UserGroupHolder usersAndGroups = this.userGroupHolder.get();
        return usersAndGroups.getAllUsers().isEmpty() && usersAndGroups.getAllGroups().isEmpty();
    }

    public String getFingerprint() throws AuthorizationAccessException {
        UserGroupHolder usersAndGroups = this.userGroupHolder.get();
        ArrayList<User> users = new ArrayList<User>(usersAndGroups.getAllUsers());
        users.sort(Comparator.comparing(User::getIdentifier));
        ArrayList<org.apache.nifi.authorization.Group> groups = new ArrayList<org.apache.nifi.authorization.Group>(usersAndGroups.getAllGroups());
        groups.sort(Comparator.comparing(org.apache.nifi.authorization.Group::getIdentifier));
        XMLStreamWriter writer = null;
        StringWriter out = new StringWriter();
        try {
            writer = XML_OUTPUT_FACTORY.createXMLStreamWriter(out);
            writer.writeStartDocument();
            writer.writeStartElement("tenants");
            for (User user : users) {
                this.writeUser(writer, user);
            }
            for (org.apache.nifi.authorization.Group group : groups) {
                this.writeGroup(writer, group);
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new AuthorizationAccessException("Unable to generate fingerprint", (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
        return out.toString();
    }

    private UsersAndGroups parseUsersAndGroups(String fingerprint) {
        ArrayList<User> users = new ArrayList<User>();
        ArrayList<org.apache.nifi.authorization.Group> groups = new ArrayList<org.apache.nifi.authorization.Group>();
        byte[] fingerprintBytes = fingerprint.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream in = new ByteArrayInputStream(fingerprintBytes);){
            StandardDocumentProvider documentProvider = new StandardDocumentProvider();
            Document document = documentProvider.parse((InputStream)in);
            Element rootElement = document.getDocumentElement();
            NodeList userNodes = rootElement.getElementsByTagName(USER_ELEMENT);
            for (int i = 0; i < userNodes.getLength(); ++i) {
                Node userNode = userNodes.item(i);
                users.add(this.parseUser((Element)userNode));
            }
            NodeList groupNodes = rootElement.getElementsByTagName(GROUP_ELEMENT);
            for (int i = 0; i < groupNodes.getLength(); ++i) {
                Node groupNode = groupNodes.item(i);
                groups.add(this.parseGroup((Element)groupNode));
            }
        }
        catch (IOException | ProcessingException e) {
            throw new AuthorizationAccessException("Unable to parse fingerprint", e);
        }
        return new UsersAndGroups(users, groups);
    }

    private User parseUser(Element element) {
        User.Builder builder = new User.Builder().identifier(element.getAttribute(IDENTIFIER_ATTR)).identity(element.getAttribute(IDENTITY_ATTR));
        return builder.build();
    }

    private org.apache.nifi.authorization.Group parseGroup(Element element) {
        Group.Builder builder = new Group.Builder().identifier(element.getAttribute(IDENTIFIER_ATTR)).name(element.getAttribute(NAME_ATTR));
        NodeList groupUsers = element.getElementsByTagName(GROUP_USER_ELEMENT);
        for (int i = 0; i < groupUsers.getLength(); ++i) {
            Element groupUserNode = (Element)groupUsers.item(i);
            builder.addUser(groupUserNode.getAttribute(IDENTIFIER_ATTR));
        }
        return builder.build();
    }

    private void writeUser(XMLStreamWriter writer, User user) throws XMLStreamException {
        writer.writeStartElement(USER_ELEMENT);
        writer.writeAttribute(IDENTIFIER_ATTR, user.getIdentifier());
        writer.writeAttribute(IDENTITY_ATTR, user.getIdentity());
        writer.writeEndElement();
    }

    private void writeGroup(XMLStreamWriter writer, org.apache.nifi.authorization.Group group) throws XMLStreamException {
        ArrayList users = new ArrayList(group.getUsers());
        Collections.sort(users);
        writer.writeStartElement(GROUP_ELEMENT);
        writer.writeAttribute(IDENTIFIER_ATTR, group.getIdentifier());
        writer.writeAttribute(NAME_ATTR, group.getName());
        for (String user : users) {
            writer.writeStartElement(GROUP_USER_ELEMENT);
            writer.writeAttribute(IDENTIFIER_ATTR, user);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private org.apache.nifi.authorization.file.tenants.generated.User createJAXBUser(User user) {
        org.apache.nifi.authorization.file.tenants.generated.User jaxbUser = new org.apache.nifi.authorization.file.tenants.generated.User();
        jaxbUser.setIdentifier(user.getIdentifier());
        jaxbUser.setIdentity(user.getIdentity());
        return jaxbUser;
    }

    private synchronized void load() throws JAXBException, IllegalStateException {
        UserGroupHolder userGroupHolder;
        boolean emptyTenants;
        Tenants tenants = this.unmarshallTenants();
        if (tenants.getUsers() == null) {
            tenants.setUsers(new Users());
        }
        if (tenants.getGroups() == null) {
            tenants.setGroups(new Groups());
        }
        boolean bl = emptyTenants = (userGroupHolder = new UserGroupHolder(tenants)).getAllUsers().isEmpty() && userGroupHolder.getAllGroups().isEmpty();
        if (emptyTenants) {
            this.populateInitialUsers(tenants);
            this.populateInitialGroups(tenants);
            this.saveAndRefreshHolder(tenants);
        } else {
            this.userGroupHolder.set(userGroupHolder);
        }
    }

    private void saveTenants(Tenants tenants) throws JAXBException {
        this.saveTenants(tenants, this.tenantsFile);
    }

    private void saveTenants(Tenants tenants, File destinationFile) throws JAXBException {
        Marshaller marshaller = JAXB_TENANTS_CONTEXT.createMarshaller();
        marshaller.setSchema(this.tenantsSchema);
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)tenants, destinationFile);
    }

    private Tenants unmarshallTenants() throws JAXBException {
        Unmarshaller unmarshaller = JAXB_TENANTS_CONTEXT.createUnmarshaller();
        unmarshaller.setSchema(this.tenantsSchema);
        StandardXMLStreamReaderProvider provider = new StandardXMLStreamReaderProvider();
        try {
            XMLStreamReader xsr = provider.getStreamReader(new StreamSource(this.tenantsFile));
            JAXBElement element = unmarshaller.unmarshal(xsr, Tenants.class);
            return (Tenants)element.getValue();
        }
        catch (ProcessingException e) {
            throw new JAXBException("Error unmarshalling tenants", (Throwable)e);
        }
    }

    private void populateInitialUsers(Tenants tenants) {
        for (String initialUserIdentity : this.initialUserIdentities) {
            this.createUser(tenants, initialUserIdentity);
        }
    }

    private void populateInitialGroups(Tenants tenants) {
        for (String initialGroupIdentity : this.initialGroupIdentities) {
            this.createGroup(tenants, initialGroupIdentity);
        }
    }

    private void createUser(Tenants tenants, String userIdentity) {
        if (StringUtils.isBlank((CharSequence)userIdentity)) {
            return;
        }
        for (org.apache.nifi.authorization.file.tenants.generated.User user : tenants.getUsers().getUser()) {
            if (!user.getIdentity().equals(userIdentity)) continue;
            return;
        }
        User builtUser = new User.Builder().identifierGenerateFromSeed(userIdentity).identity(userIdentity).build();
        org.apache.nifi.authorization.file.tenants.generated.User newUser = new org.apache.nifi.authorization.file.tenants.generated.User();
        newUser.setIdentifier(builtUser.getIdentifier());
        newUser.setIdentity(builtUser.getIdentity());
        tenants.getUsers().getUser().add(newUser);
    }

    private void createGroup(Tenants tenants, String groupName) {
        if (StringUtils.isBlank((CharSequence)groupName)) {
            return;
        }
        for (Group group : tenants.getGroups().getGroup()) {
            if (!group.getName().equals(groupName)) continue;
            return;
        }
        org.apache.nifi.authorization.Group builtGroup = new Group.Builder().identifierGenerateFromSeed(groupName).name(groupName).build();
        Group newGroup = new Group();
        newGroup.setIdentifier(builtGroup.getIdentifier());
        newGroup.setName(builtGroup.getName());
        tenants.getGroups().getGroup().add(newGroup);
    }

    private synchronized void saveAndRefreshHolder(Tenants tenants) throws AuthorizationAccessException {
        try {
            this.saveTenants(tenants);
            this.userGroupHolder.set(new UserGroupHolder(tenants));
        }
        catch (JAXBException e) {
            throw new AuthorizationAccessException("Unable to save Authorizations", (Throwable)e);
        }
    }

    public void preDestruction() throws AuthorizerDestructionException {
    }

    private static class UsersAndGroups {
        final List<User> users;
        final List<org.apache.nifi.authorization.Group> groups;

        public UsersAndGroups(List<User> users, List<org.apache.nifi.authorization.Group> groups) {
            this.users = users;
            this.groups = groups;
        }

        public List<User> getUsers() {
            return this.users;
        }

        public List<org.apache.nifi.authorization.Group> getGroups() {
            return this.groups;
        }
    }
}

