/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.AccessPolicyProviderInitializationContext;
import org.apache.nifi.authorization.AuthorizationsHolder;
import org.apache.nifi.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.authorization.ConfigurableAccessPolicyProvider;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.UserGroupProvider;
import org.apache.nifi.authorization.UserGroupProviderLookup;
import org.apache.nifi.authorization.annotation.AuthorizerContext;
import org.apache.nifi.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.authorization.exception.AuthorizerCreationException;
import org.apache.nifi.authorization.exception.AuthorizerDestructionException;
import org.apache.nifi.authorization.exception.UninheritableAuthorizationsException;
import org.apache.nifi.authorization.file.generated.Authorizations;
import org.apache.nifi.authorization.file.generated.Policies;
import org.apache.nifi.authorization.file.generated.Policy;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.authorization.util.IdentityMappingUtil;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.util.FlowInfo;
import org.apache.nifi.util.FlowParser;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.file.FileUtils;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.parsers.StandardDocumentProvider;
import org.apache.nifi.xml.processing.stream.StandardXMLStreamReaderProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FileAccessPolicyProvider
implements ConfigurableAccessPolicyProvider {
    private static final Logger logger = LoggerFactory.getLogger(FileAccessPolicyProvider.class);
    private static final String AUTHORIZATIONS_XSD = "/authorizations.xsd";
    private static final String JAXB_AUTHORIZATIONS_PATH = "org.apache.nifi.authorization.file.generated";
    private static final JAXBContext JAXB_AUTHORIZATIONS_CONTEXT = FileAccessPolicyProvider.initializeJaxbContext();
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private static final String POLICY_ELEMENT = "policy";
    private static final String POLICY_USER_ELEMENT = "policyUser";
    private static final String POLICY_GROUP_ELEMENT = "policyGroup";
    private static final String IDENTIFIER_ATTR = "identifier";
    private static final String RESOURCE_ATTR = "resource";
    private static final String ACTIONS_ATTR = "actions";
    static final String READ_CODE = "R";
    static final String WRITE_CODE = "W";
    static final String PROP_NODE_IDENTITY_PREFIX = "Node Identity ";
    static final String PROP_NODE_GROUP_NAME = "Node Group";
    static final String PROP_USER_GROUP_PROVIDER = "User Group Provider";
    static final String PROP_AUTHORIZATIONS_FILE = "Authorizations File";
    static final String PROP_INITIAL_ADMIN_IDENTITY = "Initial Admin Identity";
    static final Pattern NODE_IDENTITY_PATTERN = Pattern.compile("Node Identity \\S+");
    private Schema authorizationsSchema;
    private NiFiProperties properties;
    private File authorizationsFile;
    private File restoreAuthorizationsFile;
    private String rootGroupId;
    private String initialAdminIdentity;
    private Set<String> nodeIdentities;
    private String nodeGroupIdentifier;
    private UserGroupProvider userGroupProvider;
    private UserGroupProviderLookup userGroupProviderLookup;
    private final AtomicReference<AuthorizationsHolder> authorizationsHolder = new AtomicReference();

    private static JAXBContext initializeJaxbContext() {
        try {
            return JAXBContext.newInstance((String)JAXB_AUTHORIZATIONS_PATH, (ClassLoader)FileAccessPolicyProvider.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to create JAXBContext.");
        }
    }

    public void initialize(AccessPolicyProviderInitializationContext initializationContext) throws AuthorizerCreationException {
        this.userGroupProviderLookup = initializationContext.getUserGroupProviderLookup();
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.authorizationsSchema = schemaFactory.newSchema(FileAccessPolicyProvider.class.getResource(AUTHORIZATIONS_XSD));
        }
        catch (Exception e) {
            throw new AuthorizerCreationException((Throwable)e);
        }
    }

    public void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
        try {
            PropertyValue userGroupProviderIdentifier = configurationContext.getProperty(PROP_USER_GROUP_PROVIDER);
            if (!userGroupProviderIdentifier.isSet()) {
                throw new AuthorizerCreationException("The user group provider must be specified.");
            }
            this.userGroupProvider = this.userGroupProviderLookup.getUserGroupProvider(userGroupProviderIdentifier.getValue());
            if (this.userGroupProvider == null) {
                throw new AuthorizerCreationException("Unable to locate user group provider with identifier " + userGroupProviderIdentifier.getValue());
            }
            PropertyValue authorizationsPath = configurationContext.getProperty(PROP_AUTHORIZATIONS_FILE);
            if (StringUtils.isBlank((CharSequence)authorizationsPath.getValue())) {
                throw new AuthorizerCreationException("The authorizations file must be specified.");
            }
            this.authorizationsFile = new File(authorizationsPath.getValue());
            if (!this.authorizationsFile.exists()) {
                logger.info("Creating new authorizations file at {}", (Object)this.authorizationsFile.getAbsolutePath());
                this.saveAuthorizations(new Authorizations());
            }
            File authorizationsFileDirectory = this.authorizationsFile.getAbsoluteFile().getParentFile();
            File restoreDirectory = this.properties.getRestoreDirectory();
            if (restoreDirectory != null) {
                FileUtils.ensureDirectoryExistAndCanAccess((File)restoreDirectory);
                if (authorizationsFileDirectory.getAbsolutePath().equals(restoreDirectory.getAbsolutePath())) {
                    throw new AuthorizerCreationException(String.format("Authorizations file directory '%s' is the same as restore directory '%s' ", authorizationsFileDirectory.getAbsolutePath(), restoreDirectory.getAbsolutePath()));
                }
                this.restoreAuthorizationsFile = new File(restoreDirectory, this.authorizationsFile.getName());
                try {
                    FileUtils.syncWithRestore((File)this.authorizationsFile, (File)this.restoreAuthorizationsFile, (Logger)logger);
                }
                catch (IOException | IllegalStateException ioe) {
                    throw new AuthorizerCreationException((Throwable)ioe);
                }
            }
            List identityMappings = Collections.unmodifiableList(IdentityMappingUtil.getIdentityMappings((NiFiProperties)this.properties));
            PropertyValue initialAdminIdentityProp = configurationContext.getProperty(PROP_INITIAL_ADMIN_IDENTITY);
            this.initialAdminIdentity = initialAdminIdentityProp.isSet() ? IdentityMappingUtil.mapIdentity((String)initialAdminIdentityProp.getValue(), identityMappings) : null;
            this.nodeIdentities = new HashSet<String>();
            for (Map.Entry entry : configurationContext.getProperties().entrySet()) {
                Matcher matcher = NODE_IDENTITY_PATTERN.matcher((CharSequence)entry.getKey());
                if (!matcher.matches() || StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
                String mappedNodeIdentity = IdentityMappingUtil.mapIdentity((String)((String)entry.getValue()), identityMappings);
                this.nodeIdentities.add(mappedNodeIdentity);
                logger.info("Added mapped node {} (raw node identity {})", (Object)mappedNodeIdentity, entry.getValue());
            }
            PropertyValue nodeGroupNameProp = configurationContext.getProperty(PROP_NODE_GROUP_NAME);
            String nodeGroupName = nodeGroupNameProp != null && nodeGroupNameProp.isSet() ? nodeGroupNameProp.getValue() : null;
            this.nodeGroupIdentifier = null;
            if (nodeGroupName != null) {
                if (!StringUtils.isBlank((CharSequence)nodeGroupName)) {
                    logger.debug("Trying to load node group '{}' from the underlying userGroupProvider", (Object)nodeGroupName);
                    for (Group group : this.userGroupProvider.getGroups()) {
                        if (!group.getName().equals(nodeGroupName)) continue;
                        this.nodeGroupIdentifier = group.getIdentifier();
                        break;
                    }
                    if (this.nodeGroupIdentifier == null) {
                        throw new AuthorizerCreationException(String.format("Authorizations node group '%s' could not be found", nodeGroupName));
                    }
                } else {
                    logger.debug("Empty node group name provided");
                }
            }
            this.load();
            if (this.restoreAuthorizationsFile != null) {
                FileUtils.copyFile((File)this.authorizationsFile, (File)this.restoreAuthorizationsFile, (boolean)false, (boolean)false, (Logger)logger);
            }
            logger.debug("Authorizations file loaded");
        }
        catch (JAXBException | IOException | IllegalStateException | AuthorizerCreationException | SAXException e) {
            throw new AuthorizerCreationException(e);
        }
    }

    public UserGroupProvider getUserGroupProvider() {
        return this.userGroupProvider;
    }

    public Set<AccessPolicy> getAccessPolicies() throws AuthorizationAccessException {
        return this.authorizationsHolder.get().getAllPolicies();
    }

    public synchronized AccessPolicy addAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
        this.addAccessPolicies(Collections.singletonList(accessPolicy));
        return this.authorizationsHolder.get().getPoliciesById().get(accessPolicy.getIdentifier());
    }

    private synchronized void addAccessPolicies(List<AccessPolicy> accessPolicies) throws AuthorizationAccessException {
        if (accessPolicies == null) {
            throw new IllegalArgumentException("AccessPolicies cannot be null");
        }
        AuthorizationsHolder holder = this.authorizationsHolder.get();
        Authorizations authorizations = holder.getAuthorizations();
        List<Policy> policyList = authorizations.getPolicies().getPolicy();
        for (AccessPolicy accessPolicy : accessPolicies) {
            Policy policy = this.createJAXBPolicy(accessPolicy);
            policyList.add(policy);
        }
        this.saveAndRefreshHolder(authorizations);
    }

    public synchronized void purgePolicies(boolean save) {
        AuthorizationsHolder holder = this.authorizationsHolder.get();
        Authorizations authorizations = holder.getAuthorizations();
        List<Policy> policyList = authorizations.getPolicies().getPolicy();
        policyList.clear();
        if (save) {
            this.saveAndRefreshHolder(authorizations);
        }
    }

    public void backupPolicies() throws JAXBException {
        AuthorizationsHolder holder = this.authorizationsHolder.get();
        Authorizations authorizations = holder.getAuthorizations();
        String timestamp = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss").format(OffsetDateTime.now());
        File backupFile = new File(this.authorizationsFile.getParentFile(), this.authorizationsFile.getName() + "." + timestamp);
        logger.info("Writing backup of Policies to {}", (Object)backupFile.getAbsolutePath());
        this.saveAuthorizations(authorizations, backupFile);
    }

    public AccessPolicy getAccessPolicy(String identifier) throws AuthorizationAccessException {
        if (identifier == null) {
            return null;
        }
        AuthorizationsHolder holder = this.authorizationsHolder.get();
        return holder.getPoliciesById().get(identifier);
    }

    public AccessPolicy getAccessPolicy(String resourceIdentifier, RequestAction action) throws AuthorizationAccessException {
        return this.authorizationsHolder.get().getAccessPolicy(resourceIdentifier, action);
    }

    public synchronized AccessPolicy updateAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
        if (accessPolicy == null) {
            throw new IllegalArgumentException("AccessPolicy cannot be null");
        }
        AuthorizationsHolder holder = this.authorizationsHolder.get();
        Authorizations authorizations = holder.getAuthorizations();
        Policy updatePolicy = null;
        for (Policy policy : authorizations.getPolicies().getPolicy()) {
            if (!policy.getIdentifier().equals(accessPolicy.getIdentifier())) continue;
            updatePolicy = policy;
            break;
        }
        if (updatePolicy == null) {
            return null;
        }
        this.transferUsersAndGroups(accessPolicy, updatePolicy);
        this.saveAndRefreshHolder(authorizations);
        return this.authorizationsHolder.get().getPoliciesById().get(accessPolicy.getIdentifier());
    }

    public synchronized AccessPolicy deleteAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
        if (accessPolicy == null) {
            throw new IllegalArgumentException("AccessPolicy cannot be null");
        }
        AuthorizationsHolder holder = this.authorizationsHolder.get();
        Authorizations authorizations = holder.getAuthorizations();
        boolean deletedPolicy = false;
        Iterator<Policy> policyIter = authorizations.getPolicies().getPolicy().iterator();
        while (policyIter.hasNext()) {
            Policy policy = policyIter.next();
            if (!policy.getIdentifier().equals(accessPolicy.getIdentifier())) continue;
            policyIter.remove();
            deletedPolicy = true;
            break;
        }
        if (!deletedPolicy) {
            return null;
        }
        this.saveAndRefreshHolder(authorizations);
        return accessPolicy;
    }

    AuthorizationsHolder getAuthorizationsHolder() {
        return this.authorizationsHolder.get();
    }

    @AuthorizerContext
    public void setNiFiProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public synchronized void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
        List<AccessPolicy> accessPolicies = this.parsePolicies(fingerprint);
        this.inheritAccessPolicies(accessPolicies);
    }

    private synchronized void inheritAccessPolicies(List<AccessPolicy> accessPolicies) {
        this.addAccessPolicies(accessPolicies);
    }

    public synchronized void forciblyInheritFingerprint(String fingerprint) throws AuthorizationAccessException {
        List<AccessPolicy> accessPolicies = this.parsePolicies(fingerprint);
        if (this.isInheritable()) {
            logger.debug("Inheriting cluster's Access Policies");
            this.inheritAccessPolicies(accessPolicies);
        } else {
            logger.info("Cannot directly inherit cluster's Access Policies. Will create backup of existing policies and replace with proposed policies");
            try {
                this.backupPolicies();
            }
            catch (JAXBException jaxb) {
                throw new AuthorizationAccessException("Failed to backup existing policies so will not inherit any policies", (Throwable)jaxb);
            }
            this.purgePolicies(false);
            this.addAccessPolicies(accessPolicies);
        }
    }

    public void checkInheritability(String proposedFingerprint) throws AuthorizationAccessException, UninheritableAuthorizationsException {
        if (!this.isInheritable()) {
            throw new UninheritableAuthorizationsException("Proposed fingerprint is not inheritable because the current access policies is not empty.");
        }
    }

    private boolean isInheritable() {
        return this.getAccessPolicies().isEmpty();
    }

    public String getFingerprint() throws AuthorizationAccessException {
        ArrayList<AccessPolicy> policies = new ArrayList<AccessPolicy>(this.getAccessPolicies());
        policies.sort(Comparator.comparing(AccessPolicy::getIdentifier));
        XMLStreamWriter writer = null;
        StringWriter out = new StringWriter();
        try {
            writer = XML_OUTPUT_FACTORY.createXMLStreamWriter(out);
            writer.writeStartDocument();
            writer.writeStartElement("accessPolicies");
            for (AccessPolicy policy : policies) {
                this.writePolicy(writer, policy);
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new AuthorizationAccessException("Unable to generate fingerprint", (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
        return out.toString();
    }

    private List<AccessPolicy> parsePolicies(String fingerprint) {
        ArrayList<AccessPolicy> policies = new ArrayList<AccessPolicy>();
        byte[] fingerprintBytes = fingerprint.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream in = new ByteArrayInputStream(fingerprintBytes);){
            StandardDocumentProvider documentProvider = new StandardDocumentProvider();
            Document document = documentProvider.parse((InputStream)in);
            Element rootElement = document.getDocumentElement();
            NodeList policyNodes = rootElement.getElementsByTagName(POLICY_ELEMENT);
            for (int i = 0; i < policyNodes.getLength(); ++i) {
                Node policyNode = policyNodes.item(i);
                policies.add(this.parsePolicy((Element)policyNode));
            }
        }
        catch (IOException | ProcessingException e) {
            throw new AuthorizationAccessException("Unable to parse fingerprint", e);
        }
        return policies;
    }

    private AccessPolicy parsePolicy(Element element) {
        AccessPolicy.Builder builder = new AccessPolicy.Builder().identifier(element.getAttribute(IDENTIFIER_ATTR)).resource(element.getAttribute(RESOURCE_ATTR));
        String actions = element.getAttribute(ACTIONS_ATTR);
        if (actions.equals(RequestAction.READ.name())) {
            builder.action(RequestAction.READ);
        } else if (actions.equals(RequestAction.WRITE.name())) {
            builder.action(RequestAction.WRITE);
        } else {
            throw new IllegalStateException("Unknown Policy Action: " + actions);
        }
        NodeList policyUsers = element.getElementsByTagName(POLICY_USER_ELEMENT);
        for (int i = 0; i < policyUsers.getLength(); ++i) {
            Element policyUserNode = (Element)policyUsers.item(i);
            builder.addUser(policyUserNode.getAttribute(IDENTIFIER_ATTR));
        }
        NodeList policyGroups = element.getElementsByTagName(POLICY_GROUP_ELEMENT);
        for (int i = 0; i < policyGroups.getLength(); ++i) {
            Element policyGroupNode = (Element)policyGroups.item(i);
            builder.addGroup(policyGroupNode.getAttribute(IDENTIFIER_ATTR));
        }
        return builder.build();
    }

    private void writePolicy(XMLStreamWriter writer, AccessPolicy policy) throws XMLStreamException {
        ArrayList policyUsers = new ArrayList(policy.getUsers());
        Collections.sort(policyUsers);
        ArrayList policyGroups = new ArrayList(policy.getGroups());
        Collections.sort(policyGroups);
        writer.writeStartElement(POLICY_ELEMENT);
        writer.writeAttribute(IDENTIFIER_ATTR, policy.getIdentifier());
        writer.writeAttribute(RESOURCE_ATTR, policy.getResource());
        writer.writeAttribute(ACTIONS_ATTR, policy.getAction().name());
        for (String policyUser : policyUsers) {
            writer.writeStartElement(POLICY_USER_ELEMENT);
            writer.writeAttribute(IDENTIFIER_ATTR, policyUser);
            writer.writeEndElement();
        }
        for (String policyGroup : policyGroups) {
            writer.writeStartElement(POLICY_GROUP_ELEMENT);
            writer.writeAttribute(IDENTIFIER_ATTR, policyGroup);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private synchronized void load() throws JAXBException, IOException, IllegalStateException, SAXException {
        boolean hasInitialAdminIdentity;
        Authorizations authorizations = this.unmarshallAuthorizations();
        if (authorizations.getPolicies() == null) {
            authorizations.setPolicies(new Policies());
        }
        AuthorizationsHolder authorizationsHolder = new AuthorizationsHolder(authorizations);
        boolean emptyAuthorizations = authorizationsHolder.getAllPolicies().isEmpty();
        boolean bl = hasInitialAdminIdentity = this.initialAdminIdentity != null && !StringUtils.isBlank((CharSequence)this.initialAdminIdentity);
        if (emptyAuthorizations) {
            this.parseFlow();
            if (hasInitialAdminIdentity) {
                logger.info("Populating authorizations for Initial Admin: {}", (Object)this.initialAdminIdentity);
                this.populateInitialAdmin(authorizations);
            }
            this.populateNodes(authorizations);
            this.saveAndRefreshHolder(authorizations);
        } else {
            this.authorizationsHolder.set(authorizationsHolder);
        }
    }

    private void saveAuthorizations(Authorizations authorizations) throws JAXBException {
        this.saveAuthorizations(authorizations, this.authorizationsFile);
    }

    private void saveAuthorizations(Authorizations authorizations, File destinationFile) throws JAXBException {
        Marshaller marshaller = JAXB_AUTHORIZATIONS_CONTEXT.createMarshaller();
        marshaller.setSchema(this.authorizationsSchema);
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)authorizations, destinationFile);
    }

    private Authorizations unmarshallAuthorizations() throws JAXBException {
        try {
            StandardXMLStreamReaderProvider provider = new StandardXMLStreamReaderProvider();
            XMLStreamReader xsr = provider.getStreamReader(new StreamSource(this.authorizationsFile));
            Unmarshaller unmarshaller = JAXB_AUTHORIZATIONS_CONTEXT.createUnmarshaller();
            unmarshaller.setSchema(this.authorizationsSchema);
            JAXBElement element = unmarshaller.unmarshal(xsr, Authorizations.class);
            return (Authorizations)element.getValue();
        }
        catch (ProcessingException e) {
            logger.error("Encountered an error reading authorizations file: ", (Throwable)e);
            throw new JAXBException("Error reading authorizations file", (Throwable)e);
        }
    }

    private void parseFlow() {
        FlowParser flowParser = new FlowParser();
        File flowConfigurationFile = this.properties.getFlowConfigurationFile();
        FlowInfo flowInfo = flowParser.parse(flowConfigurationFile);
        if (flowInfo != null) {
            this.rootGroupId = flowInfo.getRootGroupId();
        }
    }

    private void populateInitialAdmin(Authorizations authorizations) {
        User initialAdmin = this.userGroupProvider.getUserByIdentity(this.initialAdminIdentity);
        if (initialAdmin == null) {
            throw new AuthorizerCreationException("Unable to locate initial admin " + this.initialAdminIdentity + " to seed policies");
        }
        this.addUserToAccessPolicy(authorizations, ResourceType.Flow.getValue(), initialAdmin.getIdentifier(), READ_CODE);
        if (this.rootGroupId != null) {
            this.addUserToAccessPolicy(authorizations, ResourceType.Data.getValue() + ResourceType.ProcessGroup.getValue() + "/" + this.rootGroupId, initialAdmin.getIdentifier(), READ_CODE);
            this.addUserToAccessPolicy(authorizations, ResourceType.Data.getValue() + ResourceType.ProcessGroup.getValue() + "/" + this.rootGroupId, initialAdmin.getIdentifier(), WRITE_CODE);
            this.addUserToAccessPolicy(authorizations, ResourceType.ProcessGroup.getValue() + "/" + this.rootGroupId, initialAdmin.getIdentifier(), READ_CODE);
            this.addUserToAccessPolicy(authorizations, ResourceType.ProcessGroup.getValue() + "/" + this.rootGroupId, initialAdmin.getIdentifier(), WRITE_CODE);
        }
        this.addUserToAccessPolicy(authorizations, ResourceType.RestrictedComponents.getValue(), initialAdmin.getIdentifier(), WRITE_CODE);
        this.addUserToAccessPolicy(authorizations, ResourceType.Tenant.getValue(), initialAdmin.getIdentifier(), READ_CODE);
        this.addUserToAccessPolicy(authorizations, ResourceType.Tenant.getValue(), initialAdmin.getIdentifier(), WRITE_CODE);
        this.addUserToAccessPolicy(authorizations, ResourceType.Policy.getValue(), initialAdmin.getIdentifier(), READ_CODE);
        this.addUserToAccessPolicy(authorizations, ResourceType.Policy.getValue(), initialAdmin.getIdentifier(), WRITE_CODE);
        this.addUserToAccessPolicy(authorizations, ResourceType.Controller.getValue(), initialAdmin.getIdentifier(), READ_CODE);
        this.addUserToAccessPolicy(authorizations, ResourceType.Controller.getValue(), initialAdmin.getIdentifier(), WRITE_CODE);
    }

    private void populateNodes(Authorizations authorizations) {
        for (String nodeIdentity : this.nodeIdentities) {
            User node = this.userGroupProvider.getUserByIdentity(nodeIdentity);
            if (node == null) {
                throw new AuthorizerCreationException("Unable to locate node " + nodeIdentity + " to seed policies.");
            }
            logger.debug("Populating default authorizations for node '{}' ({})", (Object)node.getIdentity(), (Object)node.getIdentifier());
            this.addUserToAccessPolicy(authorizations, ResourceType.Proxy.getValue(), node.getIdentifier(), WRITE_CODE);
            this.addUserToAccessPolicy(authorizations, ResourceType.Controller.getValue(), node.getIdentifier(), READ_CODE);
            if (this.rootGroupId == null) continue;
            this.addUserToAccessPolicy(authorizations, ResourceType.Data.getValue() + ResourceType.ProcessGroup.getValue() + "/" + this.rootGroupId, node.getIdentifier(), READ_CODE);
            this.addUserToAccessPolicy(authorizations, ResourceType.Data.getValue() + ResourceType.ProcessGroup.getValue() + "/" + this.rootGroupId, node.getIdentifier(), WRITE_CODE);
        }
        if (this.nodeGroupIdentifier != null) {
            logger.debug("Populating default authorizations for group '{}' ({})", (Object)this.userGroupProvider.getGroup(this.nodeGroupIdentifier).getName(), (Object)this.nodeGroupIdentifier);
            this.addGroupToAccessPolicy(authorizations, ResourceType.Proxy.getValue(), this.nodeGroupIdentifier, WRITE_CODE);
            if (this.rootGroupId != null) {
                this.addGroupToAccessPolicy(authorizations, ResourceType.Data.getValue() + ResourceType.ProcessGroup.getValue() + "/" + this.rootGroupId, this.nodeGroupIdentifier, READ_CODE);
                this.addGroupToAccessPolicy(authorizations, ResourceType.Data.getValue() + ResourceType.ProcessGroup.getValue() + "/" + this.rootGroupId, this.nodeGroupIdentifier, WRITE_CODE);
            }
        }
    }

    private void addUserToAccessPolicy(Authorizations authorizations, String resource, String userIdentifier, String action) {
        Policy foundPolicy = null;
        for (Policy policy : authorizations.getPolicies().getPolicy()) {
            if (!policy.getResource().equals(resource) || !policy.getAction().equals(action)) continue;
            foundPolicy = policy;
            break;
        }
        if (foundPolicy == null) {
            String uuidSeed = resource + action;
            AccessPolicy.Builder builder = new AccessPolicy.Builder().identifierGenerateFromSeed(uuidSeed).resource(resource).addUser(userIdentifier);
            if (action.equals(READ_CODE)) {
                builder.action(RequestAction.READ);
            } else if (action.equals(WRITE_CODE)) {
                builder.action(RequestAction.WRITE);
            } else {
                throw new IllegalStateException("Unknown Policy Action: " + action);
            }
            AccessPolicy accessPolicy = builder.build();
            Policy jaxbPolicy = this.createJAXBPolicy(accessPolicy);
            authorizations.getPolicies().getPolicy().add(jaxbPolicy);
        } else {
            Policy.User policyUser = new Policy.User();
            policyUser.setIdentifier(userIdentifier);
            foundPolicy.getUser().add(policyUser);
        }
    }

    private void addGroupToAccessPolicy(Authorizations authorizations, String resource, String groupIdentifier, String action) {
        Policy foundPolicy = null;
        for (Policy policy : authorizations.getPolicies().getPolicy()) {
            if (!policy.getResource().equals(resource) || !policy.getAction().equals(action)) continue;
            foundPolicy = policy;
            break;
        }
        if (foundPolicy == null) {
            String uuidSeed = resource + action;
            AccessPolicy.Builder builder = new AccessPolicy.Builder().identifierGenerateFromSeed(uuidSeed).resource(resource).addGroup(groupIdentifier);
            if (action.equals(READ_CODE)) {
                builder.action(RequestAction.READ);
            } else if (action.equals(WRITE_CODE)) {
                builder.action(RequestAction.WRITE);
            } else {
                throw new IllegalStateException("Unknown Policy Action: " + action);
            }
            AccessPolicy accessPolicy = builder.build();
            Policy jaxbPolicy = this.createJAXBPolicy(accessPolicy);
            authorizations.getPolicies().getPolicy().add(jaxbPolicy);
        } else {
            Policy.Group policyGroup = new Policy.Group();
            policyGroup.setIdentifier(groupIdentifier);
            foundPolicy.getGroup().add(policyGroup);
        }
    }

    private Policy createJAXBPolicy(AccessPolicy accessPolicy) {
        Policy policy = new Policy();
        policy.setIdentifier(accessPolicy.getIdentifier());
        policy.setResource(accessPolicy.getResource());
        switch (accessPolicy.getAction()) {
            case READ: {
                policy.setAction(READ_CODE);
                break;
            }
            case WRITE: {
                policy.setAction(WRITE_CODE);
                break;
            }
        }
        this.transferUsersAndGroups(accessPolicy, policy);
        return policy;
    }

    private void transferUsersAndGroups(AccessPolicy accessPolicy, Policy policy) {
        policy.getUser().clear();
        for (String userIdentifier : accessPolicy.getUsers()) {
            Policy.User policyUser = new Policy.User();
            policyUser.setIdentifier(userIdentifier);
            policy.getUser().add(policyUser);
        }
        policy.getGroup().clear();
        for (String groupIdentifier : accessPolicy.getGroups()) {
            Policy.Group policyGroup = new Policy.Group();
            policyGroup.setIdentifier(groupIdentifier);
            policy.getGroup().add(policyGroup);
        }
    }

    private synchronized void saveAndRefreshHolder(Authorizations authorizations) throws AuthorizationAccessException {
        try {
            this.saveAuthorizations(authorizations);
            this.authorizationsHolder.set(new AuthorizationsHolder(authorizations));
        }
        catch (JAXBException e) {
            throw new AuthorizationAccessException("Unable to save Authorizations", (Throwable)e);
        }
    }

    public void preDestruction() throws AuthorizerDestructionException {
    }
}

