/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx.parser;

import com.google.common.primitives.UnsignedInteger;
import java.io.IOException;

public class NumberUtil {
    public static final String EXPECTED_TEXT = " Expected %s got %s.";

    public static int intValueExpected(Number number, int expected, String errorMessage, Object ... args) throws IOException {
        int result = number.intValue();
        if (result != expected) {
            throw NumberUtil.createException(errorMessage, args, expected, result);
        }
        return result;
    }

    public static int intValueMax(UnsignedInteger unsignedInteger, int max, String errorMessage, Object ... args) throws IOException {
        if (unsignedInteger.compareTo(UnsignedInteger.valueOf((long)max)) > 0) {
            throw NumberUtil.createException(errorMessage, args, "< " + max, unsignedInteger);
        }
        return unsignedInteger.intValue();
    }

    private static IOException createException(String errorMessage, Object[] args, Object expected, Object actual) {
        return new IOException(String.format(errorMessage, args) + String.format(EXPECTED_TEXT, expected, actual));
    }
}

