/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx.parser.bxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.processors.evtx.parser.BinaryReader;
import org.apache.nifi.processors.evtx.parser.Block;
import org.apache.nifi.processors.evtx.parser.BxmlNodeVisitor;
import org.apache.nifi.processors.evtx.parser.ChunkHeader;
import org.apache.nifi.processors.evtx.parser.bxml.AttributeNode;
import org.apache.nifi.processors.evtx.parser.bxml.BxmlNodeFactory;
import org.apache.nifi.processors.evtx.parser.bxml.CDataSectionNode;
import org.apache.nifi.processors.evtx.parser.bxml.CloseElementNode;
import org.apache.nifi.processors.evtx.parser.bxml.CloseEmptyElementNode;
import org.apache.nifi.processors.evtx.parser.bxml.CloseStartElementNode;
import org.apache.nifi.processors.evtx.parser.bxml.ConditionalSubstitutionNode;
import org.apache.nifi.processors.evtx.parser.bxml.EndOfStreamNode;
import org.apache.nifi.processors.evtx.parser.bxml.EntityReferenceNode;
import org.apache.nifi.processors.evtx.parser.bxml.NormalSubstitutionNode;
import org.apache.nifi.processors.evtx.parser.bxml.OpenStartElementNode;
import org.apache.nifi.processors.evtx.parser.bxml.ProcessingInstructionDataNode;
import org.apache.nifi.processors.evtx.parser.bxml.ProcessingInstructionTargetNode;
import org.apache.nifi.processors.evtx.parser.bxml.StreamStartNode;
import org.apache.nifi.processors.evtx.parser.bxml.TemplateInstanceNode;
import org.apache.nifi.processors.evtx.parser.bxml.ValueNode;

public abstract class BxmlNode
extends Block {
    public static final int END_OF_STREAM_TOKEN = 0;
    public static final int OPEN_START_ELEMENT_TOKEN = 1;
    public static final int CLOSE_START_ELEMENT_TOKEN = 2;
    public static final int CLOSE_EMPTY_ELEMENT_TOKEN = 3;
    public static final int CLOSE_ELEMENT_TOKEN = 4;
    public static final int VALUE_TOKEN = 5;
    public static final int ATTRIBUTE_TOKEN = 6;
    public static final int C_DATA_SECTION_TOKEN = 7;
    public static final int ENTITY_REFERENCE_TOKEN = 8;
    public static final int PROCESSING_INSTRUCTION_TARGET_TOKEN = 10;
    public static final int PROCESSING_INSTRUCTION_DATA_TOKEN = 11;
    public static final int TEMPLATE_INSTANCE_TOKEN = 12;
    public static final int NORMAL_SUBSTITUTION_TOKEN = 13;
    public static final int CONDITIONAL_SUBSTITUTION_TOKEN = 14;
    public static final int START_OF_STREAM_TOKEN = 15;
    private static final BxmlNodeFactory[] factories = new BxmlNodeFactory[]{EndOfStreamNode::new, OpenStartElementNode::new, CloseStartElementNode::new, CloseEmptyElementNode::new, CloseElementNode::new, ValueNode::new, AttributeNode::new, CDataSectionNode::new, null, EntityReferenceNode::new, ProcessingInstructionTargetNode::new, ProcessingInstructionDataNode::new, TemplateInstanceNode::new, NormalSubstitutionNode::new, ConditionalSubstitutionNode::new, StreamStartNode::new};
    private final ChunkHeader chunkHeader;
    private final BxmlNode parent;
    protected List<BxmlNode> children;
    private boolean hasEndOfStream = false;

    protected BxmlNode(BinaryReader binaryReader, ChunkHeader chunkHeader, BxmlNode parent) {
        super(binaryReader, chunkHeader.getOffset() + (long)binaryReader.getPosition());
        this.chunkHeader = chunkHeader;
        this.parent = parent;
        this.hasEndOfStream = false;
    }

    @Override
    protected void init(boolean shouldClearBinaryReader) throws IOException {
        super.init(false);
        this.children = Collections.unmodifiableList(this.initChildren());
        if (shouldClearBinaryReader) {
            this.clearBinaryReader();
        }
    }

    protected List<BxmlNode> initChildren() throws IOException {
        BinaryReader binaryReader = this.getBinaryReader();
        ArrayList<BxmlNode> result = new ArrayList<BxmlNode>();
        int maxChildren = this.getMaxChildren();
        int[] endTokens = this.getEndTokens();
        for (int i = 0; i < maxChildren; ++i) {
            int token = binaryReader.peek();
            int factoryIndex = token & 0xF;
            if (factoryIndex > factories.length - 1) {
                throw new IOException("Invalid token " + factoryIndex);
            }
            BxmlNodeFactory factory = factories[factoryIndex];
            if (factory == null) {
                throw new IOException("Invalid token " + factoryIndex);
            }
            BxmlNode bxmlNode = factory.create(binaryReader, this.chunkHeader, this);
            result.add(bxmlNode);
            if (bxmlNode.hasEndOfStream() || bxmlNode instanceof EndOfStreamNode) {
                this.hasEndOfStream = true;
                break;
            }
            if (Arrays.binarySearch(endTokens, factoryIndex) >= 0) break;
        }
        return result;
    }

    protected int getMaxChildren() {
        return Integer.MAX_VALUE;
    }

    protected int[] getEndTokens() {
        return new int[]{0};
    }

    public List<BxmlNode> getChildren() {
        if (!this.isInitialized()) {
            throw new RuntimeException("Need to initialize children");
        }
        return this.children;
    }

    public ChunkHeader getChunkHeader() {
        return this.chunkHeader;
    }

    public BxmlNode getParent() {
        return this.parent;
    }

    public boolean hasEndOfStream() {
        return this.hasEndOfStream;
    }

    public abstract void accept(BxmlNodeVisitor var1) throws IOException;
}

