/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx.parser;

import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;

public class BinaryReader {
    public static final long EPOCH_OFFSET = 11644473600000L;
    public static final int[][] INDEX_ARRAYS = new int[][]{{3, 2, 1, 0}, {5, 4}, {7, 6}, {8, 9}, {10, 11, 12, 13, 14, 15}};
    private final byte[] bytes;
    private int position;

    public BinaryReader(BinaryReader binaryReader, int position) {
        this.bytes = binaryReader.bytes;
        this.position = position;
    }

    public BinaryReader(InputStream inputStream, int size) throws IOException {
        byte[] bytes = new byte[size];
        for (int read = 0; read < size; read += inputStream.read(bytes, read, size - read)) {
        }
        this.bytes = bytes;
        this.position = 0;
    }

    public BinaryReader(byte[] bytes) {
        this.bytes = bytes;
        this.position = 0;
    }

    public int read() {
        return this.bytes[this.position++];
    }

    public int peek() {
        return this.bytes[this.position];
    }

    public byte[] peekBytes(int length) {
        return Arrays.copyOfRange(this.bytes, this.position, this.position + length);
    }

    public byte[] readBytes(int length) {
        byte[] result = this.peekBytes(length);
        this.position += length;
        return result;
    }

    public void readBytes(byte[] buf, int offset, int length) {
        System.arraycopy(this.bytes, this.position, buf, offset, length);
        this.position += length;
    }

    public String readGuid() {
        StringBuilder result = new StringBuilder();
        int maxIndex = 0;
        int[][] nArray = INDEX_ARRAYS;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] indexArray;
            for (int index : indexArray = nArray[i]) {
                maxIndex = Math.max(maxIndex, index);
                result.append(String.format("%02X", this.bytes[this.position + index]).toLowerCase());
            }
            result.append("-");
        }
        result.setLength(result.length() - 1);
        this.position += maxIndex + 1;
        return result.toString();
    }

    public String readString(int length) throws IOException {
        StringBuilder result = new StringBuilder(length - 1);
        boolean foundNull = false;
        int exclusiveLastIndex = this.position + length;
        for (int i = this.position; i < exclusiveLastIndex; ++i) {
            byte b = this.bytes[i];
            if (b == 0) {
                foundNull = true;
                break;
            }
            result.append((char)b);
        }
        if (!foundNull) {
            throw new IOException("Expected null terminated string");
        }
        this.position += length;
        return result.toString();
    }

    public String readWString(int length) {
        int numBytes = length * 2;
        String result = StandardCharsets.UTF_16LE.decode(ByteBuffer.wrap(this.bytes, this.position, numBytes)).toString();
        this.position += numBytes;
        return result;
    }

    public UnsignedLong readQWord() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.bytes, this.position, 8);
        this.position += 8;
        return UnsignedLong.fromLongBits((long)byteBuffer.order(ByteOrder.LITTLE_ENDIAN).getLong());
    }

    public UnsignedInteger readDWord() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.bytes, this.position, 4);
        this.position += 4;
        return UnsignedInteger.fromIntBits((int)byteBuffer.order(ByteOrder.LITTLE_ENDIAN).getInt());
    }

    public UnsignedInteger readDWordBE() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.bytes, this.position, 4);
        this.position += 4;
        return UnsignedInteger.fromIntBits((int)byteBuffer.order(ByteOrder.BIG_ENDIAN).getInt());
    }

    public int readWord() {
        byte[] bytes = new byte[4];
        this.readBytes(bytes, 0, 2);
        return ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public int readWordBE() {
        byte[] bytes = new byte[4];
        this.readBytes(bytes, 2, 2);
        return ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN).getInt();
    }

    public Date readFileTime() {
        UnsignedLong hundredsOfNanosecondsSinceJan11601 = this.readQWord();
        long millisecondsSinceJan11601 = hundredsOfNanosecondsSinceJan11601.dividedBy(UnsignedLong.valueOf((long)10000L)).longValue();
        long millisecondsSinceEpoch = millisecondsSinceJan11601 - 11644473600000L;
        return new Date(millisecondsSinceEpoch);
    }

    public String readAndBase64EncodeBinary(int length) {
        return Base64.getEncoder().encodeToString(this.readBytes(length));
    }

    public void skip(int bytes) {
        this.position += bytes;
    }

    public int getPosition() {
        return this.position;
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

