/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.embedded.database;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.UUID;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.dbcp.DBCPService;

public class EmbeddedDatabaseConnectionService
extends AbstractControllerService
implements DBCPService,
Closeable {
    private static final String CONNECTION_URL_FORMAT = "jdbc:hsqldb:file:%s;hsqldb.lock_file=false;hsqldb.log_data=false;hsqldb.log_size=0";
    private static final String DRIVER_CLASS = "org.hsqldb.jdbc.JDBCDriver";
    private static final String SHUTDOWN_COMMAND = "SHUTDOWN";
    private final String connectionUrl;

    public EmbeddedDatabaseConnectionService(Path databaseLocation) {
        Objects.requireNonNull(databaseLocation, "Database Location required");
        String randomDirectory = UUID.randomUUID().toString();
        Path serviceDirectory = databaseLocation.resolve(randomDirectory).toAbsolutePath();
        this.connectionUrl = CONNECTION_URL_FORMAT.formatted(serviceDirectory);
        try {
            Class.forName(DRIVER_CLASS);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("JDBC Driver [%s] not found".formatted(DRIVER_CLASS), e);
        }
    }

    public Connection getConnection() {
        try {
            return DriverManager.getConnection(this.connectionUrl);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Connection retrieval failed [%s]".formatted(this.connectionUrl), e);
        }
    }

    @Override
    @OnDisabled
    public void close() throws IOException {
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(SHUTDOWN_COMMAND);
        }
        catch (SQLException e) {
            throw new IOException("Shutdown command failed", e);
        }
    }
}

