/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.elasticsearch;

import java.util.List;
import org.apache.nifi.annotation.behavior.DynamicProperties;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.elasticsearch.SearchResponse;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processors.elasticsearch.AbstractPaginatedJsonQueryElasticsearch;
import org.apache.nifi.processors.elasticsearch.ConsumeElasticsearch;
import org.apache.nifi.processors.elasticsearch.JsonQueryElasticsearch;
import org.apache.nifi.processors.elasticsearch.SearchElasticsearch;
import org.apache.nifi.processors.elasticsearch.api.PaginatedJsonQueryParameters;

@WritesAttributes(value={@WritesAttribute(attribute="mime.type", description="application/json"), @WritesAttribute(attribute="aggregation.name", description="The name of the aggregation whose results are in the output flowfile"), @WritesAttribute(attribute="aggregation.number", description="The number of the aggregation whose results are in the output flowfile"), @WritesAttribute(attribute="page.number", description="The number of the page (request), starting from 1, in which the results were returned that are in the output flowfile"), @WritesAttribute(attribute="hit.count", description="The number of hits that are in the output flowfile"), @WritesAttribute(attribute="elasticsearch.query.error", description="The error message provided by Elasticsearch if there is an error querying the index.")})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"elasticsearch", "elasticsearch5", "elasticsearch6", "elasticsearch7", "elasticsearch8", "query", "scroll", "page", "read", "json"})
@CapabilityDescription(value="A processor that allows the user to run a paginated query (with aggregations) written with the Elasticsearch JSON DSL. It will use the flowfile's content for the query unless the QUERY attribute is populated. Search After/Point in Time queries must include a valid \"sort\" field.")
@SeeAlso(value={JsonQueryElasticsearch.class, ConsumeElasticsearch.class, SearchElasticsearch.class})
@DynamicProperties(value={@DynamicProperty(name="The name of the HTTP request header", value="A Record Path expression to retrieve the HTTP request header value", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="Prefix: HEADER: - adds the specified property name/value as a HTTP request header in the Elasticsearch request. If the Record Path expression results in a null or blank value, the HTTP request header will be omitted."), @DynamicProperty(name="The name of a URL query parameter to add", value="The value of the URL query parameter", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="Adds the specified property name/value as a query parameter in the Elasticsearch URL used for processing. These parameters will override any matching parameters in the query request body. For SCROLL type queries, these parameters are only used in the initial (first page) query as the Elasticsearch Scroll API does not support the same query parameters for subsequent pages of data.")})
@SystemResourceConsideration(resource=SystemResource.MEMORY, description="Care should be taken on the size of each page because each response from Elasticsearch will be loaded into memory all at once and converted into the resulting flowfiles.")
public class PaginatedJsonQueryElasticsearch
extends AbstractPaginatedJsonQueryElasticsearch {
    @Override
    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return paginatedPropertyDescriptors;
    }

    @Override
    void finishQuery(FlowFile input, PaginatedJsonQueryParameters paginatedQueryJsonParameters, ProcessSession session, ProcessContext context, SearchResponse response) {
        session.transfer(input, REL_ORIGINAL);
    }

    @Override
    void resetQueryParamsIfRequired(PaginatedJsonQueryParameters paginatedQueryJsonParameters, ProcessContext context) {
    }

    @Override
    String getScrollId(ProcessContext context, SearchResponse response) {
        return response != null ? response.getScrollId() : null;
    }

    @Override
    String getPitId(ProcessContext context, SearchResponse response) {
        return response != null ? response.getPitId() : null;
    }
}

