/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.dropbox;

import java.util.function.Function;
import org.apache.nifi.processors.dropbox.DropboxFileInfo;

public enum DropboxFlowFileAttribute {
    ID("dropbox.id", DropboxFileInfo::getId),
    PATH("path", DropboxFileInfo::getPath),
    FILENAME("filename", DropboxFileInfo::getName),
    SIZE("dropbox.size", fileInfo -> String.valueOf(fileInfo.getSize())),
    TIMESTAMP("dropbox.timestamp", fileInfo -> String.valueOf(fileInfo.getTimestamp())),
    REVISION("dropbox.revision", DropboxFileInfo::getRevision);

    private final String name;
    private final Function<DropboxFileInfo, String> fromFileInfo;

    private DropboxFlowFileAttribute(String attributeName, Function<DropboxFileInfo, String> fromFileInfo) {
        this.name = attributeName;
        this.fromFileInfo = fromFileInfo;
    }

    public String getName() {
        return this.name;
    }

    public String getValue(DropboxFileInfo fileInfo) {
        return this.fromFileInfo.apply(fileInfo);
    }
}

