/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server;

import java.util.Comparator;
import org.apache.nifi.distributed.cache.server.CacheRecord;

public enum EvictionPolicy {
    LFU(new LFUComparator()),
    LRU(new LRUComparator()),
    FIFO(new FIFOComparator());

    private final Comparator<CacheRecord> comparator;

    private EvictionPolicy(Comparator<CacheRecord> comparator) {
        this.comparator = comparator;
    }

    public Comparator<CacheRecord> getComparator() {
        return this.comparator;
    }

    public static class LFUComparator
    implements Comparator<CacheRecord> {
        @Override
        public int compare(CacheRecord o1, CacheRecord o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            int hitCountComparison = Integer.compare(o1.getHitCount(), o2.getHitCount());
            int entryDateComparison = hitCountComparison == 0 ? Long.compare(o1.getEntryDate(), o2.getEntryDate()) : hitCountComparison;
            return entryDateComparison == 0 ? Long.compare(o1.getId(), o2.getId()) : entryDateComparison;
        }
    }

    public static class LRUComparator
    implements Comparator<CacheRecord> {
        @Override
        public int compare(CacheRecord o1, CacheRecord o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            int lastHitDateComparison = Long.compare(o1.getLastHitDate(), o2.getLastHitDate());
            return lastHitDateComparison == 0 ? Long.compare(o1.getId(), o2.getId()) : lastHitDateComparison;
        }
    }

    public static class FIFOComparator
    implements Comparator<CacheRecord> {
        @Override
        public int compare(CacheRecord o1, CacheRecord o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            int entryDateComparison = Long.compare(o1.getEntryDate(), o2.getEntryDate());
            return entryDateComparison == 0 ? Long.compare(o1.getId(), o2.getId()) : entryDateComparison;
        }
    }
}

