/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server.set;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.nifi.distributed.cache.server.CacheRecord;
import org.apache.nifi.distributed.cache.server.EvictionPolicy;
import org.apache.nifi.distributed.cache.server.set.SetCache;
import org.apache.nifi.distributed.cache.server.set.SetCacheRecord;
import org.apache.nifi.distributed.cache.server.set.SetCacheResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSetCache
implements SetCache {
    private static final Logger logger = LoggerFactory.getLogger(SimpleSetCache.class);
    private final Map<ByteBuffer, SetCacheRecord> cache = new HashMap<ByteBuffer, SetCacheRecord>();
    private final SortedMap<SetCacheRecord, ByteBuffer> inverseCacheMap;
    private final String serviceIdentifier;
    private final int maxSize;

    public SimpleSetCache(String serviceIdentifier, int maxSize, EvictionPolicy evictionPolicy) {
        this.inverseCacheMap = new TreeMap<CacheRecord, ByteBuffer>(evictionPolicy.getComparator());
        this.serviceIdentifier = serviceIdentifier;
        this.maxSize = maxSize;
    }

    private synchronized SetCacheRecord evict() {
        if (this.cache.size() < this.maxSize) {
            return null;
        }
        SetCacheRecord recordToEvict = this.inverseCacheMap.firstKey();
        ByteBuffer valueToEvict = (ByteBuffer)this.inverseCacheMap.remove(recordToEvict);
        this.cache.remove(valueToEvict);
        if (logger.isDebugEnabled()) {
            logger.debug("Evicting value {} from cache", (Object)new String(valueToEvict.array(), StandardCharsets.UTF_8));
        }
        return recordToEvict;
    }

    @Override
    public synchronized SetCacheResult addIfAbsent(ByteBuffer value) {
        SetCacheRecord record = this.cache.get(value);
        if (record == null) {
            SetCacheRecord evicted = this.evict();
            SetCacheRecord newRecord = new SetCacheRecord(value);
            this.cache.put(value, newRecord);
            this.inverseCacheMap.put(newRecord, value);
            return new SetCacheResult(true, newRecord, evicted);
        }
        this.inverseCacheMap.remove(record);
        record.hit();
        this.inverseCacheMap.put(record, value);
        return new SetCacheResult(false, record, null);
    }

    @Override
    public synchronized SetCacheResult contains(ByteBuffer value) {
        SetCacheRecord record = this.cache.get(value);
        if (record == null) {
            return new SetCacheResult(false, null, null);
        }
        this.inverseCacheMap.remove(record);
        record.hit();
        this.inverseCacheMap.put(record, value);
        return new SetCacheResult(true, record, null);
    }

    @Override
    public synchronized SetCacheResult remove(ByteBuffer value) {
        SetCacheRecord record = this.cache.remove(value);
        if (record == null) {
            return new SetCacheResult(false, null, null);
        }
        this.inverseCacheMap.remove(record);
        return new SetCacheResult(true, record, null);
    }

    public String toString() {
        return "SimpleSetCache[service id=" + this.serviceIdentifier + "]";
    }

    @Override
    public void shutdown() throws IOException {
    }
}

