/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.server.protocol;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.distributed.cache.operations.CacheOperation;

public class MapCacheRequest {
    private final CacheOperation cacheOperation;
    private byte[] key;
    private byte[] value;
    private String pattern;
    private long revision;
    private List<byte[]> keys = Collections.emptyList();

    public MapCacheRequest(CacheOperation cacheOperation) {
        this.cacheOperation = Objects.requireNonNull(cacheOperation, "Cache Operation required");
    }

    public MapCacheRequest(CacheOperation cacheOperation, byte[] key) {
        this(cacheOperation);
        this.key = Objects.requireNonNull(key, "Key required");
    }

    public MapCacheRequest(CacheOperation cacheOperation, byte[] key, byte[] value) {
        this(cacheOperation, key);
        this.value = Objects.requireNonNull(value, "Value required");
    }

    public MapCacheRequest(CacheOperation cacheOperation, byte[] key, long revision, byte[] value) {
        this(cacheOperation, key, value);
        this.revision = revision;
    }

    public MapCacheRequest(CacheOperation cacheOperation, String pattern) {
        this(cacheOperation);
        this.pattern = Objects.requireNonNull(pattern, "Pattern required");
    }

    public MapCacheRequest(CacheOperation cacheOperation, List<byte[]> keys) {
        this(cacheOperation);
        this.keys = Objects.requireNonNull(keys, "Keys required");
    }

    public CacheOperation getCacheOperation() {
        return this.cacheOperation;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public String getPattern() {
        return this.pattern;
    }

    public long getRevision() {
        return this.revision;
    }

    public List<byte[]> getKeys() {
        return this.keys;
    }
}

