/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client.adapter;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.distributed.cache.client.Deserializer;
import org.apache.nifi.distributed.cache.client.adapter.InboundAdapter;
import org.apache.nifi.distributed.cache.client.adapter.InboundToken;

public class MapValuesInboundAdapter<K, V>
implements InboundAdapter {
    private final Iterator<K> iteratorKeys;
    private final Deserializer<V> deserializerV;
    private final ByteBuf byteBuf;
    private final InboundToken<V> inboundToken;
    private final Map<K, V> result;

    public MapValuesInboundAdapter(Set<K> keys, Deserializer<V> deserializerV, Map<K, V> result) {
        this.iteratorKeys = keys.iterator();
        this.deserializerV = deserializerV;
        this.byteBuf = Unpooled.buffer();
        this.inboundToken = new InboundToken();
        this.result = result;
    }

    public Map<K, V> getResult() {
        return this.result;
    }

    @Override
    public boolean isComplete() {
        return !this.iteratorKeys.hasNext();
    }

    @Override
    public void queue(byte[] bytes) {
        this.byteBuf.writeBytes(bytes);
    }

    @Override
    public void dequeue() throws IOException {
        while (this.iteratorKeys.hasNext()) {
            this.inboundToken.update(this.byteBuf, this.deserializerV);
            if (!this.inboundToken.isComplete()) break;
            this.result.put(this.iteratorKeys.next(), this.inboundToken.getValue());
            this.inboundToken.reset();
        }
    }
}

