/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.database.dialect.service;

import java.sql.JDBCType;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.database.dialect.service.api.ColumnDefinition;
import org.apache.nifi.database.dialect.service.api.DatabaseDialectService;
import org.apache.nifi.database.dialect.service.api.PageRequest;
import org.apache.nifi.database.dialect.service.api.QueryStatementRequest;
import org.apache.nifi.database.dialect.service.api.StandardStatementResponse;
import org.apache.nifi.database.dialect.service.api.StatementRequest;
import org.apache.nifi.database.dialect.service.api.StatementResponse;
import org.apache.nifi.database.dialect.service.api.StatementType;
import org.apache.nifi.database.dialect.service.api.TableDefinition;

@CapabilityDescription(value="    Database Dialect Service supporting ANSI SQL.\n    Supported Statement Types: ALTER, CREATE, SELECT\n")
@Tags(value={"Relational", "Database", "JDBC", "SQL"})
public class StandardDatabaseDialectService
extends AbstractControllerService
implements DatabaseDialectService {
    private static final char PERIOD_SEPARATOR = '.';
    private static final char SPACE_SEPARATOR = ' ';
    private static final char COMMA_SEPARATOR = ',';
    private static final char ASTERISK_CHARACTER = '*';
    private static final String NOT_NULL_QUALIFIER = "NOT NULL";
    private static final String PRIMARY_KEY_QUALIFIER = "PRIMARY KEY";
    private static final String WHERE_KEYWORD = "WHERE";
    private static final String ORDER_BY_KEYWORD = "ORDER BY";
    private static final String AND_KEYWORD = "AND";
    private static final String LIMIT_KEYWORD = "LIMIT";
    private static final String OFFSET_KEYWORD = "OFFSET";
    private static final String GREATER_THAN_OR_EQUAL = ">=";
    private static final String LESS_THAN = "<";
    private static final Set<StatementType> supportedStatementTypes = Set.of(StatementType.ALTER, StatementType.CREATE, StatementType.SELECT);

    public StatementResponse getStatement(StatementRequest statementRequest) {
        Objects.requireNonNull(statementRequest, "Statement Request required");
        return this.getSupportedStatement(statementRequest);
    }

    public Set<StatementType> getSupportedStatementTypes() {
        return supportedStatementTypes;
    }

    private StatementResponse getSupportedStatement(StatementRequest statementRequest) {
        StatementType statementType = statementRequest.statementType();
        return switch (statementType) {
            case StatementType.ALTER -> this.getAlterStatement(statementRequest);
            case StatementType.CREATE -> this.getCreateStatement(statementRequest);
            case StatementType.SELECT -> this.getSelectStatement(statementRequest);
            default -> throw new UnsupportedOperationException("Statement Type [%s] not handled".formatted(statementType));
        };
    }

    private StatementResponse getAlterStatement(StatementRequest statementRequest) {
        TableDefinition tableDefinition = statementRequest.tableDefinition();
        String qualifiedTableName = this.getQualifiedTableName(tableDefinition);
        String tableColumns = this.getAlterTableColumns(tableDefinition.columns());
        String sql = "ALTER TABLE %s ADD COLUMNS (%s)".formatted(qualifiedTableName, tableColumns);
        return new StandardStatementResponse(sql);
    }

    private String getAlterTableColumns(List<ColumnDefinition> columnDefinitions) {
        StringBuilder tableColumns = new StringBuilder();
        Iterator<ColumnDefinition> columns = columnDefinitions.iterator();
        while (columns.hasNext()) {
            ColumnDefinition columnDefinition = columns.next();
            String columnName = columnDefinition.columnName();
            String jdbcTypeName = this.getJdbcTypeName(columnDefinition);
            tableColumns.append(columnName);
            tableColumns.append(' ');
            tableColumns.append(jdbcTypeName);
            if (ColumnDefinition.Nullable.NO == columnDefinition.nullable()) {
                tableColumns.append(' ');
                tableColumns.append(NOT_NULL_QUALIFIER);
            }
            if (!columns.hasNext()) continue;
            tableColumns.append(',');
            tableColumns.append(' ');
        }
        return tableColumns.toString();
    }

    private StatementResponse getCreateStatement(StatementRequest statementRequest) {
        TableDefinition tableDefinition = statementRequest.tableDefinition();
        String qualifiedTableName = this.getQualifiedTableName(tableDefinition);
        String tableColumns = this.getCreateTableColumns(tableDefinition.columns());
        String sql = "CREATE TABLE %s (%s)".formatted(qualifiedTableName, tableColumns);
        return new StandardStatementResponse(sql);
    }

    private String getCreateTableColumns(List<ColumnDefinition> columnDefinitions) {
        StringBuilder tableColumns = new StringBuilder();
        Iterator<ColumnDefinition> columns = columnDefinitions.iterator();
        while (columns.hasNext()) {
            ColumnDefinition columnDefinition = columns.next();
            String columnName = columnDefinition.columnName();
            String jdbcTypeName = this.getJdbcTypeName(columnDefinition);
            tableColumns.append(columnName);
            tableColumns.append(' ');
            tableColumns.append(jdbcTypeName);
            if (ColumnDefinition.Nullable.NO == columnDefinition.nullable()) {
                tableColumns.append(' ');
                tableColumns.append(NOT_NULL_QUALIFIER);
            }
            if (columnDefinition.primaryKey()) {
                tableColumns.append(' ');
                tableColumns.append(PRIMARY_KEY_QUALIFIER);
            }
            if (!columns.hasNext()) continue;
            tableColumns.append(',');
            tableColumns.append(' ');
        }
        return tableColumns.toString();
    }

    private String getSelectTableColumns(List<ColumnDefinition> columnDefinitions) {
        StringBuilder tableColumns = new StringBuilder();
        Iterator<ColumnDefinition> columns = columnDefinitions.iterator();
        if (columns.hasNext()) {
            while (columns.hasNext()) {
                ColumnDefinition columnDefinition = columns.next();
                String columnName = columnDefinition.columnName();
                tableColumns.append(columnName);
                if (!columns.hasNext()) continue;
                tableColumns.append(',');
                tableColumns.append(' ');
            }
        } else {
            tableColumns.append('*');
        }
        return tableColumns.toString();
    }

    private StatementResponse getSelectStatement(StatementRequest statementRequest) {
        if (statementRequest instanceof QueryStatementRequest) {
            Optional orderByQueryClause;
            String selectSql;
            QueryStatementRequest queryStatementRequest = (QueryStatementRequest)statementRequest;
            TableDefinition tableDefinition = queryStatementRequest.tableDefinition();
            String qualifiedTableName = this.getQualifiedTableName(tableDefinition);
            Optional derivedTableFound = queryStatementRequest.derivedTable();
            if (derivedTableFound.isPresent()) {
                String derivedTable = (String)derivedTableFound.get();
                selectSql = "SELECT * FROM (%s) AS %s".formatted(derivedTable, qualifiedTableName);
            } else {
                String tableColumns = this.getSelectTableColumns(tableDefinition.columns());
                selectSql = "SELECT %s FROM %s".formatted(tableColumns, qualifiedTableName);
            }
            StringBuilder sqlBuilder = new StringBuilder(selectSql);
            Optional pageRequestFound = queryStatementRequest.pageRequest();
            Optional whereQueryClause = queryStatementRequest.whereClause();
            if (whereQueryClause.isPresent()) {
                sqlBuilder.append(' ');
                sqlBuilder.append(WHERE_KEYWORD);
                sqlBuilder.append(' ');
                sqlBuilder.append((String)whereQueryClause.get());
                if (pageRequestFound.isPresent()) {
                    PageRequest pageRequest = (PageRequest)pageRequestFound.get();
                    this.appendIndexedPageRequest(pageRequest, sqlBuilder);
                }
            }
            if ((orderByQueryClause = queryStatementRequest.orderByClause()).isPresent()) {
                sqlBuilder.append(' ');
                sqlBuilder.append(ORDER_BY_KEYWORD);
                sqlBuilder.append(' ');
                sqlBuilder.append((String)orderByQueryClause.get());
            }
            if (pageRequestFound.isPresent()) {
                PageRequest pageRequest = (PageRequest)pageRequestFound.get();
                this.appendPageRequest(pageRequest, sqlBuilder);
            }
            return new StandardStatementResponse(sqlBuilder.toString());
        }
        throw new IllegalArgumentException("Query Statement Request not found [%s]".formatted(statementRequest.getClass()));
    }

    private void appendPageRequest(PageRequest pageRequest, StringBuilder sqlBuilder) {
        Optional indexColumnNameFound = pageRequest.indexColumnName();
        if (indexColumnNameFound.isEmpty()) {
            OptionalLong limitFound = pageRequest.limit();
            if (limitFound.isPresent()) {
                sqlBuilder.append(' ');
                sqlBuilder.append(LIMIT_KEYWORD);
                sqlBuilder.append(' ');
                sqlBuilder.append(limitFound.getAsLong());
            }
            sqlBuilder.append(' ');
            sqlBuilder.append(OFFSET_KEYWORD);
            sqlBuilder.append(' ');
            sqlBuilder.append(pageRequest.offset());
        }
    }

    private void appendIndexedPageRequest(PageRequest pageRequest, StringBuilder sqlBuilder) {
        Optional indexColumnNameFound = pageRequest.indexColumnName();
        if (indexColumnNameFound.isPresent()) {
            sqlBuilder.append(' ');
            sqlBuilder.append(AND_KEYWORD);
            sqlBuilder.append(' ');
            String indexColumnName = (String)indexColumnNameFound.get();
            sqlBuilder.append(indexColumnName);
            sqlBuilder.append(' ');
            sqlBuilder.append(GREATER_THAN_OR_EQUAL);
            sqlBuilder.append(' ');
            sqlBuilder.append(pageRequest.offset());
            OptionalLong limitFound = pageRequest.limit();
            if (limitFound.isPresent()) {
                sqlBuilder.append(' ');
                sqlBuilder.append(AND_KEYWORD);
                sqlBuilder.append(' ');
                sqlBuilder.append(indexColumnName);
                sqlBuilder.append(' ');
                sqlBuilder.append(LESS_THAN);
                sqlBuilder.append(' ');
                sqlBuilder.append(limitFound.getAsLong());
            }
        }
    }

    private String getQualifiedTableName(TableDefinition tableDefinition) {
        Optional schemaName;
        StringBuilder builder = new StringBuilder();
        Optional catalog = tableDefinition.catalog();
        if (catalog.isPresent()) {
            builder.append((String)catalog.get());
            builder.append('.');
        }
        if ((schemaName = tableDefinition.schemaName()).isPresent()) {
            builder.append((String)schemaName.get());
            builder.append('.');
        }
        builder.append(tableDefinition.tableName());
        return builder.toString();
    }

    private String getJdbcTypeName(ColumnDefinition columnDefinition) {
        int dataType = columnDefinition.dataType();
        JDBCType jdbcType = JDBCType.valueOf(dataType);
        return jdbcType.getName();
    }
}

