/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;

public class PlaceholderProvenanceEvent
implements ProvenanceEventRecord {
    private final String componentId;
    private final long eventId;
    private final long eventTime;
    private final String flowFileUuid;

    public PlaceholderProvenanceEvent(ProvenanceEventRecord original) {
        this.componentId = original.getComponentId();
        this.eventId = original.getEventId();
        this.eventTime = original.getEventTime();
        this.flowFileUuid = original.getFlowFileUuid();
    }

    public long getEventId() {
        return this.eventId;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public long getFlowFileEntryDate() {
        return 0L;
    }

    public long getLineageStartDate() {
        return 0L;
    }

    public long getFileSize() {
        return -1L;
    }

    public Long getPreviousFileSize() {
        return -1L;
    }

    public long getEventDuration() {
        return -1L;
    }

    public ProvenanceEventType getEventType() {
        return ProvenanceEventType.UNKNOWN;
    }

    public Map<String, String> getAttributes() {
        return Collections.emptyMap();
    }

    public Map<String, String> getPreviousAttributes() {
        return Collections.emptyMap();
    }

    public Map<String, String> getUpdatedAttributes() {
        return Collections.emptyMap();
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getComponentType() {
        return null;
    }

    public String getTransitUri() {
        return null;
    }

    public String getSourceSystemFlowFileIdentifier() {
        return null;
    }

    public String getFlowFileUuid() {
        return this.flowFileUuid;
    }

    public List<String> getParentUuids() {
        return null;
    }

    public List<String> getChildUuids() {
        return null;
    }

    public String getAlternateIdentifierUri() {
        return null;
    }

    public String getDetails() {
        return null;
    }

    public String getRelationship() {
        return null;
    }

    public String getSourceQueueIdentifier() {
        return null;
    }

    public String getContentClaimSection() {
        return null;
    }

    public String getPreviousContentClaimSection() {
        return null;
    }

    public String getContentClaimContainer() {
        return null;
    }

    public String getPreviousContentClaimContainer() {
        return null;
    }

    public String getContentClaimIdentifier() {
        return null;
    }

    public String getPreviousContentClaimIdentifier() {
        return null;
    }

    public Long getContentClaimOffset() {
        return null;
    }

    public Long getPreviousContentClaimOffset() {
        return null;
    }

    public String getBestEventIdentifier() {
        return Long.toString(this.getEventId());
    }
}

