/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.couchbase;

import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.ReadsAttributes;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.couchbase.AbstractCouchbaseProcessor;
import org.apache.nifi.services.couchbase.CouchbaseClient;
import org.apache.nifi.services.couchbase.CouchbaseConnectionService;
import org.apache.nifi.services.couchbase.exception.CouchbaseException;
import org.apache.nifi.services.couchbase.utils.CouchbaseContext;
import org.apache.nifi.services.couchbase.utils.CouchbaseUpsertResult;

@Tags(value={"nosql", "couchbase", "database", "put"})
@CapabilityDescription(value="Put a document to Couchbase Server.")
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@ReadsAttributes(value={@ReadsAttribute(attribute="uuid", description="Used as a document id if 'Document Id' is not specified")})
@WritesAttributes(value={@WritesAttribute(attribute="couchbase.bucket", description="The bucket where the document is stored."), @WritesAttribute(attribute="couchbase.scope", description="The scope where the document is stored."), @WritesAttribute(attribute="couchbase.collection", description="The collection where the document is stored."), @WritesAttribute(attribute="couchbase.document.id", description="Id of the document."), @WritesAttribute(attribute="couchbase.document.cas", description="CAS of the document.")})
public class PutCouchbase
extends AbstractCouchbaseProcessor {
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        long startNanos = System.nanoTime();
        CouchbaseConnectionService connectionService = (CouchbaseConnectionService)context.getProperty(COUCHBASE_CONNECTION_SERVICE).asControllerService(CouchbaseConnectionService.class);
        String documentId = context.getProperty(DOCUMENT_ID).evaluateAttributeExpressions(flowFile).getValue();
        CouchbaseContext couchbaseContext = this.getCouchbaseContext(context, flowFile);
        CouchbaseClient couchbaseClient = connectionService.getClient(couchbaseContext);
        try {
            CouchbaseUpsertResult result = couchbaseClient.upsertDocument(documentId, this.readFlowFileContent(session, flowFile));
            flowFile = session.putAllAttributes(flowFile, this.getFlowfileAttributes(couchbaseContext, documentId, String.valueOf(result.cas())));
            long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            session.getProvenanceReporter().send(flowFile, this.createTransitUri(connectionService.getServiceLocation(), couchbaseContext, documentId), transferMillis);
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (CouchbaseException e) {
            this.handleCouchbaseException(couchbaseClient, context, session, this.getLogger(), flowFile, e, "Failed to upsert document into Couchbase");
        }
    }
}

