/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.couchbase;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.services.couchbase.CouchbaseClient;
import org.apache.nifi.services.couchbase.CouchbaseConnectionService;
import org.apache.nifi.services.couchbase.exception.CouchbaseException;
import org.apache.nifi.services.couchbase.exception.ExceptionCategory;
import org.apache.nifi.services.couchbase.utils.CouchbaseContext;
import org.apache.nifi.services.couchbase.utils.DocumentType;
import org.apache.nifi.stream.io.StreamUtils;

public abstract class AbstractCouchbaseProcessor
extends AbstractProcessor {
    protected CouchbaseConnectionService connectionService;
    public static final PropertyDescriptor DOCUMENT_ID = new PropertyDescriptor.Builder().name("Document ID").description("Couchbase document identifier, or an expression to construct the Couchbase document identifier.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor COUCHBASE_CONNECTION_SERVICE = new PropertyDescriptor.Builder().name("Couchbase Connection Service").description("A Couchbase Connection Service which manages connections to a Couchbase cluster.").required(true).identifiesControllerService(CouchbaseConnectionService.class).build();
    public static final PropertyDescriptor BUCKET_NAME = new PropertyDescriptor.Builder().name("Bucket Name").description("The name of the bucket where documents will be stored. Each bucket contains a hierarchy of scopes and collections to group keys and values logically.").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).defaultValue("default").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor SCOPE_NAME = new PropertyDescriptor.Builder().name("Scope Name").description("The name of the scope  which is a logical namespace within a bucket, serving to categorize and organize related collections.").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).defaultValue("_default").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor COLLECTION_NAME = new PropertyDescriptor.Builder().name("Collection Name").description("The name of collection which is a logical container within a scope, used to hold documents.").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).defaultValue("_default").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor DOCUMENT_TYPE = new PropertyDescriptor.Builder().name("Document Type").description("The content type for storing the document.").required(true).allowableValues((Enum[])DocumentType.values()).defaultValue(DocumentType.JSON.toString()).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile is routed to this relationship after the data ingestion was successful.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile is routed to this relationship if the operation failed and retrying the operation will also fail, such as an invalid data or schema.").build();
    public static final Relationship REL_RETRY = new Relationship.Builder().name("retry").description("All FlowFile that fail due to server/cluster availability go to this relationship.").build();
    private static final List<PropertyDescriptor> PROPERTIES = List.of(COUCHBASE_CONNECTION_SERVICE, BUCKET_NAME, SCOPE_NAME, COLLECTION_NAME, DOCUMENT_TYPE, DOCUMENT_ID);
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE, REL_RETRY);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.connectionService = (CouchbaseConnectionService)context.getProperty(COUCHBASE_CONNECTION_SERVICE).asControllerService(CouchbaseConnectionService.class);
    }

    protected byte[] readFlowFileContent(ProcessSession session, FlowFile flowFile) {
        byte[] content = new byte[(int)flowFile.getSize()];
        session.read(flowFile, in -> StreamUtils.fillBuffer((InputStream)in, (byte[])content, (boolean)true));
        return content;
    }

    protected String createTransitUri(String serviceLocation, CouchbaseContext context, String documentId) {
        return String.join((CharSequence)"/", serviceLocation, context.bucket(), context.scope(), context.collection(), documentId);
    }

    protected CouchbaseContext getCouchbaseContext(ProcessContext context, FlowFile flowFile) {
        String bucketName = context.getProperty(BUCKET_NAME).evaluateAttributeExpressions(flowFile).getValue();
        String scopeName = context.getProperty(SCOPE_NAME).evaluateAttributeExpressions(flowFile).getValue();
        String collectionName = context.getProperty(COLLECTION_NAME).evaluateAttributeExpressions(flowFile).getValue();
        DocumentType documentType = DocumentType.valueOf((String)context.getProperty(DOCUMENT_TYPE).getValue());
        return new CouchbaseContext(bucketName, scopeName, collectionName, documentType);
    }

    protected Map<String, String> getFlowfileAttributes(CouchbaseContext context, String documentId, String cas) {
        return new HashMap<String, String>(Map.of("couchbase.bucket", context.bucket(), "couchbase.scope", context.scope(), "couchbase.collection", context.collection(), "couchbase.document.id", documentId, "couchbase.document.cas", cas));
    }

    protected void handleCouchbaseException(CouchbaseClient couchbaseClient, ProcessContext context, ProcessSession session, ComponentLog logger, FlowFile flowFile, CouchbaseException e, String errorMessage) {
        Object throwable = e.getCause() != null ? e.getCause() : e;
        logger.error(errorMessage, (Throwable)throwable);
        ExceptionCategory exceptionCategory = couchbaseClient.getExceptionCategory((Throwable)throwable);
        switch (exceptionCategory) {
            case ROLLBACK: {
                session.rollback();
                break;
            }
            case FAILURE: {
                context.yield();
                session.transfer(flowFile, REL_FAILURE);
                break;
            }
            case RETRY: {
                session.transfer(flowFile, REL_RETRY);
            }
        }
    }
}

