/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.couchbase;

import com.couchbase.client.core.BackpressureException;
import com.couchbase.client.core.BucketClosedException;
import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.DocumentConcurrentlyModifiedException;
import com.couchbase.client.core.DocumentMutationLostException;
import com.couchbase.client.core.ReplicaNotConfiguredException;
import com.couchbase.client.core.RequestCancelledException;
import com.couchbase.client.core.ServiceNotAvailableException;
import com.couchbase.client.core.config.ConfigurationException;
import com.couchbase.client.core.endpoint.SSLException;
import com.couchbase.client.core.endpoint.kv.AuthenticationException;
import com.couchbase.client.core.env.EnvironmentException;
import com.couchbase.client.core.state.NotConnectedException;
import com.couchbase.client.java.error.BucketDoesNotExistException;
import com.couchbase.client.java.error.CannotRetryException;
import com.couchbase.client.java.error.CouchbaseOutOfMemoryException;
import com.couchbase.client.java.error.DurabilityException;
import com.couchbase.client.java.error.InvalidPasswordException;
import com.couchbase.client.java.error.RequestTooBigException;
import com.couchbase.client.java.error.TemporaryFailureException;
import com.couchbase.client.java.error.TranscodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.processors.couchbase.ErrorHandlingStrategy;

public class CouchbaseExceptionMappings {
    private static final Map<Class<? extends CouchbaseException>, ErrorHandlingStrategy> mapping = new HashMap<Class<? extends CouchbaseException>, ErrorHandlingStrategy>();

    public static ErrorHandlingStrategy getStrategy(CouchbaseException e) {
        ErrorHandlingStrategy strategy = mapping.get(((Object)((Object)e)).getClass());
        if (strategy == null) {
            return ErrorHandlingStrategy.Fatal;
        }
        return strategy;
    }

    static {
        mapping.put(AuthenticationException.class, ErrorHandlingStrategy.ConfigurationError);
        mapping.put(BucketDoesNotExistException.class, ErrorHandlingStrategy.ConfigurationError);
        mapping.put(ConfigurationException.class, ErrorHandlingStrategy.ConfigurationError);
        mapping.put(InvalidPasswordException.class, ErrorHandlingStrategy.ConfigurationError);
        mapping.put(EnvironmentException.class, ErrorHandlingStrategy.ConfigurationError);
        mapping.put(ReplicaNotConfiguredException.class, ErrorHandlingStrategy.ConfigurationError);
        mapping.put(ServiceNotAvailableException.class, ErrorHandlingStrategy.ConfigurationError);
        mapping.put(SSLException.class, ErrorHandlingStrategy.ConfigurationError);
        mapping.put(RequestTooBigException.class, ErrorHandlingStrategy.InvalidInput);
        mapping.put(TranscodingException.class, ErrorHandlingStrategy.InvalidInput);
        mapping.put(BackpressureException.class, ErrorHandlingStrategy.TemporalClusterError);
        mapping.put(CouchbaseOutOfMemoryException.class, ErrorHandlingStrategy.TemporalClusterError);
        mapping.put(TemporaryFailureException.class, ErrorHandlingStrategy.TemporalClusterError);
        mapping.put(RequestCancelledException.class, ErrorHandlingStrategy.TemporalClusterError);
        mapping.put(DocumentConcurrentlyModifiedException.class, ErrorHandlingStrategy.TemporalFlowFileError);
        mapping.put(DocumentMutationLostException.class, ErrorHandlingStrategy.TemporalFlowFileError);
        mapping.put(DurabilityException.class, ErrorHandlingStrategy.TemporalFlowFileError);
        mapping.put(BucketClosedException.class, ErrorHandlingStrategy.Fatal);
        mapping.put(CannotRetryException.class, ErrorHandlingStrategy.Fatal);
        mapping.put(NotConnectedException.class, ErrorHandlingStrategy.Fatal);
    }
}

