/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.couchbase;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.java.Bucket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.couchbase.CouchbaseClusterControllerService;
import org.apache.nifi.couchbase.CouchbaseConfigurationProperties;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.couchbase.CouchbaseAttributes;
import org.apache.nifi.processors.couchbase.CouchbaseExceptionMappings;
import org.apache.nifi.processors.couchbase.ErrorHandlingStrategy;

public abstract class AbstractCouchbaseProcessor
extends AbstractProcessor {
    static final PropertyDescriptor DOC_ID = new PropertyDescriptor.Builder().name("document-id").displayName("Document Id").description("A static, fixed Couchbase document id, or an expression to construct the Couchbase document id.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").build();
    static final Relationship REL_RETRY = new Relationship.Builder().name("retry").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").build();
    private List<PropertyDescriptor> descriptors;
    private Set<Relationship> relationships;
    private CouchbaseClusterControllerService clusterService;

    protected final void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(CouchbaseConfigurationProperties.COUCHBASE_CLUSTER_SERVICE);
        descriptors.add(CouchbaseConfigurationProperties.BUCKET_NAME);
        this.addSupportedProperties(descriptors);
        this.descriptors = Collections.unmodifiableList(descriptors);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        this.addSupportedRelationships(relationships);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    protected void addSupportedProperties(List<PropertyDescriptor> descriptors) {
    }

    protected void addSupportedRelationships(Set<Relationship> relationships) {
    }

    public final Set<Relationship> getRelationships() {
        return this.filterRelationships(this.relationships);
    }

    protected Set<Relationship> filterRelationships(Set<Relationship> rels) {
        return rels;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.descriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CouchbaseClusterControllerService getClusterService(ProcessContext context) {
        Class<AbstractCouchbaseProcessor> clazz = AbstractCouchbaseProcessor.class;
        synchronized (AbstractCouchbaseProcessor.class) {
            if (this.clusterService == null) {
                this.clusterService = (CouchbaseClusterControllerService)context.getProperty(CouchbaseConfigurationProperties.COUCHBASE_CLUSTER_SERVICE).asControllerService(CouchbaseClusterControllerService.class);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.clusterService;
        }
    }

    protected final Bucket openBucket(ProcessContext context) {
        return this.getClusterService(context).openBucket(context.getProperty(CouchbaseConfigurationProperties.BUCKET_NAME).evaluateAttributeExpressions().getValue());
    }

    protected String getTransitUrl(Bucket bucket, String docId) {
        return "couchbase://" + bucket.name() + "/" + docId;
    }

    protected void handleCouchbaseException(ProcessContext context, ProcessSession session, ComponentLog logger, FlowFile inFile, CouchbaseException e, String errMsg) {
        logger.error(errMsg, (Throwable)e);
        if (inFile != null) {
            ErrorHandlingStrategy strategy = CouchbaseExceptionMappings.getStrategy(e);
            switch (strategy.penalty()) {
                case Penalize: {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Penalized: {}", new Object[]{inFile});
                    }
                    inFile = session.penalize(inFile);
                    break;
                }
                case Yield: {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Yielded context: {}", new Object[]{inFile});
                    }
                    context.yield();
                    break;
                }
            }
            switch (strategy.result()) {
                case ProcessException: {
                    throw new ProcessException(errMsg, (Throwable)e);
                }
                case Failure: {
                    inFile = session.putAttribute(inFile, CouchbaseAttributes.Exception.key(), ((Object)((Object)e)).getClass().getName());
                    session.transfer(inFile, REL_FAILURE);
                    break;
                }
                case Retry: {
                    inFile = session.putAttribute(inFile, CouchbaseAttributes.Exception.key(), ((Object)((Object)e)).getClass().getName());
                    session.transfer(inFile, REL_RETRY);
                }
            }
        }
    }
}

