/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.web.ContentRequestContext;

public class HttpServletContentRequestContext
implements ContentRequestContext {
    private final String dataRef;
    private final String clusterNodeId;
    private final String clientId;
    private static final String PROXY_CONTEXT_PATH_HTTP_HEADER = "X-ProxyContextPath";
    private static final String FORWARDED_CONTEXT_HTTP_HEADER = "X-Forwarded-Context";
    private static final String FORWARDED_PREFIX_HTTP_HEADER = "X-Forwarded-Prefix";

    public HttpServletContentRequestContext(HttpServletRequest request) {
        String[] queryParameters;
        String ref = request.getParameter("ref");
        UriBuilder refUriBuilder = UriBuilder.fromUri((String)ref);
        refUriBuilder.scheme(request.getScheme());
        String proxyContextPath = this.getFirstHeaderValue(request, PROXY_CONTEXT_PATH_HTTP_HEADER, FORWARDED_CONTEXT_HTTP_HEADER, FORWARDED_PREFIX_HTTP_HEADER);
        if (StringUtils.isNotBlank((CharSequence)proxyContextPath)) {
            refUriBuilder.replacePath(StringUtils.substringAfter((String)UriBuilder.fromUri((String)ref).build(new Object[0]).getPath(), (String)proxyContextPath));
        }
        URI refUri = refUriBuilder.build(new Object[0]);
        String query = refUri.getQuery();
        String rawClusterNodeId = null;
        if (query != null && (queryParameters = query.split("&"))[0].startsWith("clusterNodeId=")) {
            rawClusterNodeId = StringUtils.substringAfterLast((String)queryParameters[0], (String)"clusterNodeId=");
        }
        String clusterNodeId = rawClusterNodeId;
        this.dataRef = refUri.toString();
        this.clusterNodeId = clusterNodeId;
        this.clientId = request.getParameter("clientId");
    }

    private String getFirstHeaderValue(HttpServletRequest httpServletRequest, String ... keys) {
        if (keys == null) {
            return null;
        }
        for (String key : keys) {
            String value = httpServletRequest.getHeader(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public String getDataUri() {
        return this.dataRef;
    }

    public String getClusterNodeId() {
        return this.clusterNodeId;
    }

    public String getClientId() {
        return this.clientId;
    }
}

