/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.conflict.resolution;

import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.components.DescribedValue;

public enum ConflictResolutionStrategy implements DescribedValue
{
    FAIL("fail", "Handle file conflict as failure."),
    IGNORE("ignore", "Ignore conflict, do not change the original file."),
    REPLACE("replace", "Replace existing file in case of conflict.");

    private static final Map<String, ConflictResolutionStrategy> ENUM_MAP;
    private final String value;
    private final String description;

    private ConflictResolutionStrategy(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public static ConflictResolutionStrategy forValue(String value) {
        return ENUM_MAP.get(value);
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        ENUM_MAP = new HashMap<String, ConflictResolutionStrategy>();
        for (ConflictResolutionStrategy strategy : ConflictResolutionStrategy.values()) {
            ENUM_MAP.put(strategy.getValue(), strategy);
        }
    }
}

