/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.cipher.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.nifi.processor.io.StreamCallback;

public class ChannelStreamCallback
implements StreamCallback {
    private static final int END_OF_FILE = -1;
    private final int bufferCapacity;

    public ChannelStreamCallback(int bufferCapacity) {
        this.bufferCapacity = bufferCapacity;
    }

    public void process(InputStream inputStream, OutputStream outputStream) throws IOException {
        try (ReadableByteChannel readableByteChannel = this.getReadableChannel(inputStream);
             WritableByteChannel outputChannel = this.getWritableChannel(outputStream);){
            ByteBuffer buffer = ByteBuffer.allocate(this.bufferCapacity);
            while (readableByteChannel.read(buffer) != -1) {
                buffer.flip();
                while (buffer.hasRemaining()) {
                    outputChannel.write(buffer);
                }
                buffer.clear();
            }
            buffer.flip();
            if (buffer.hasRemaining()) {
                while (buffer.hasRemaining()) {
                    outputChannel.write(buffer);
                }
            }
        }
    }

    protected ReadableByteChannel getReadableChannel(InputStream inputStream) throws IOException {
        return Channels.newChannel(inputStream);
    }

    protected WritableByteChannel getWritableChannel(OutputStream outputStream) throws IOException {
        return Channels.newChannel(outputStream);
    }
}

