/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.mysql.event.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import org.apache.nifi.cdc.event.EventInfo;
import org.apache.nifi.cdc.event.io.EventWriterConfiguration;
import org.apache.nifi.cdc.mysql.event.DDLEventInfo;
import org.apache.nifi.cdc.mysql.event.io.AbstractBinlogTableEventWriter;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;

public class DDLEventWriter
extends AbstractBinlogTableEventWriter<DDLEventInfo> {
    @Override
    public long writeEvent(ProcessSession session, String transitUri, DDLEventInfo eventInfo, long currentSequenceId, Relationship relationship, EventWriterConfiguration eventWriterConfiguration) {
        this.configureEventWriter(eventWriterConfiguration, session, eventInfo);
        OutputStream outputStream = eventWriterConfiguration.getFlowFileOutputStream();
        try {
            super.startJson(outputStream, (EventInfo)eventInfo);
            super.writeJson(eventInfo);
            this.jsonGenerator.writeStringField("query", eventInfo.getQuery());
            super.endJson();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Write JSON start array failed", ioe);
        }
        eventWriterConfiguration.incrementNumberOfEventsWritten();
        if (this.maxEventsPerFlowFile(eventWriterConfiguration) && eventWriterConfiguration.getNumberOfEventsWritten() == eventWriterConfiguration.getNumberOfEventsPerFlowFile()) {
            this.finishAndTransferFlowFile(session, eventWriterConfiguration, transitUri, currentSequenceId, eventInfo, relationship);
        }
        return currentSequenceId + 1L;
    }
}

