/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.mysql.event.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.BitSet;
import java.util.Map;
import org.apache.nifi.cdc.event.ColumnDefinition;
import org.apache.nifi.cdc.event.EventInfo;
import org.apache.nifi.cdc.event.io.EventWriterConfiguration;
import org.apache.nifi.cdc.mysql.event.UpdateRowsEventInfo;
import org.apache.nifi.cdc.mysql.event.io.AbstractBinlogTableEventWriter;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;

public class UpdateRowsWriter
extends AbstractBinlogTableEventWriter<UpdateRowsEventInfo> {
    @Override
    public long writeEvent(ProcessSession session, String transitUri, UpdateRowsEventInfo eventInfo, long currentSequenceId, Relationship relationship, EventWriterConfiguration eventWriterConfiguration) {
        long seqId = currentSequenceId;
        for (Map.Entry row : eventInfo.getRows()) {
            this.configureEventWriter(eventWriterConfiguration, session, eventInfo);
            OutputStream outputStream = eventWriterConfiguration.getFlowFileOutputStream();
            try {
                super.startJson(outputStream, (EventInfo)eventInfo);
                super.writeJson(eventInfo);
                BitSet bitSet = eventInfo.getIncludedColumns();
                this.writeRow(eventInfo, row, bitSet);
                super.endJson();
            }
            catch (IOException ioe) {
                throw new UncheckedIOException("Write JSON start array failed", ioe);
            }
            eventWriterConfiguration.incrementNumberOfEventsWritten();
            if (this.maxEventsPerFlowFile(eventWriterConfiguration) && eventWriterConfiguration.getNumberOfEventsWritten() == eventWriterConfiguration.getNumberOfEventsPerFlowFile()) {
                this.finishAndTransferFlowFile(session, eventWriterConfiguration, transitUri, seqId, eventInfo, relationship);
            }
            ++seqId;
        }
        return seqId;
    }

    protected void writeRow(UpdateRowsEventInfo event, Map.Entry<Serializable[], Serializable[]> row, BitSet includedColumns) throws IOException {
        this.jsonGenerator.writeArrayFieldStart("columns");
        int i = includedColumns.nextSetBit(0);
        while (i != -1) {
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeNumberField("id", i + 1);
            ColumnDefinition columnDefinition = event.getColumnByIndex(i);
            Integer columnType = null;
            if (columnDefinition != null) {
                this.jsonGenerator.writeStringField("name", columnDefinition.getName());
                columnType = columnDefinition.getType();
                this.jsonGenerator.writeNumberField("column_type", columnType.intValue());
            }
            Serializable[] oldRow = row.getKey();
            Serializable[] newRow = row.getValue();
            if (oldRow[i] == null) {
                this.jsonGenerator.writeNullField("last_value");
            } else {
                this.jsonGenerator.writeObjectField("last_value", this.getWritableObject(columnType, oldRow[i]));
            }
            if (newRow[i] == null) {
                this.jsonGenerator.writeNullField("value");
            } else {
                this.jsonGenerator.writeObjectField("value", this.getWritableObject(columnType, newRow[i]));
            }
            this.jsonGenerator.writeEndObject();
            i = includedColumns.nextSetBit(i + 1);
        }
        this.jsonGenerator.writeEndArray();
    }
}

