/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.mysql.event.handler;

import com.github.shyiko.mysql.binlog.event.QueryEventData;
import org.apache.nifi.cdc.event.TableInfo;
import org.apache.nifi.cdc.event.io.EventWriterConfiguration;
import org.apache.nifi.cdc.mysql.event.DDLEventInfo;
import org.apache.nifi.cdc.mysql.event.DataCaptureState;
import org.apache.nifi.cdc.mysql.event.handler.BinlogEventHandler;
import org.apache.nifi.cdc.mysql.event.io.DDLEventWriter;
import org.apache.nifi.cdc.mysql.processors.CaptureChangeMySQL;
import org.apache.nifi.processor.ProcessSession;

public class DDLEventHandler
implements BinlogEventHandler<QueryEventData, DDLEventInfo> {
    private final DDLEventWriter eventWriter = new DDLEventWriter();

    @Override
    public void handleEvent(QueryEventData eventData, boolean writeEvent, DataCaptureState dataCaptureState, CaptureChangeMySQL.BinlogResourceInfo binlogResourceInfo, CaptureChangeMySQL.BinlogEventState binlogEventState, String sql, EventWriterConfiguration eventWriterConfiguration, ProcessSession session, long timestamp) {
        if (writeEvent) {
            TableInfo ddlTableInfo = binlogResourceInfo.getCurrentTable() != null ? binlogResourceInfo.getCurrentTable() : new TableInfo(binlogResourceInfo.getCurrentDatabase(), null, null, null);
            DDLEventInfo ddlEvent = dataCaptureState.isUseGtid() ? new DDLEventInfo(ddlTableInfo, (Long)timestamp, dataCaptureState.getGtidSet(), sql) : new DDLEventInfo(ddlTableInfo, timestamp, dataCaptureState.getBinlogFile(), dataCaptureState.getBinlogPosition(), sql);
            binlogEventState.setCurrentEventInfo(ddlEvent);
            binlogEventState.setCurrentEventWriter(this.eventWriter);
            dataCaptureState.setSequenceId(this.eventWriter.writeEvent(session, binlogResourceInfo.getTransitUri(), ddlEvent, dataCaptureState.getSequenceId(), CaptureChangeMySQL.REL_SUCCESS, eventWriterConfiguration));
        }
    }
}

