/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.sql.internal;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.nifi.sql.internal.CalciteTable;
import org.apache.nifi.sql.internal.NiFiProjectTableScanRule;

class NiFiTableScan
extends TableScan
implements EnumerableRel {
    private final ConstantExpression fieldExpression;
    private final int[] fields;

    protected NiFiTableScan(RelOptCluster cluster, RelOptTable table, int[] fields) {
        super(cluster, cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE), Collections.emptyList(), table);
        this.fields = fields;
        this.fieldExpression = Expressions.constant((Object)fields);
        try {
            cluster.getPlanner().addRule((RelOptRule)new NiFiProjectTableScanRule(NiFiProjectTableScanRule.Config.DEFAULT));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void register(RelOptPlanner planner) {
        planner.addRule((RelOptRule)new NiFiProjectTableScanRule(NiFiProjectTableScanRule.Config.DEFAULT));
    }

    public RelDataType deriveRowType() {
        List fieldList = this.table.getRowType().getFieldList();
        RelDataTypeFactory.FieldInfoBuilder builder = this.getCluster().getTypeFactory().builder();
        for (int field : this.fields) {
            builder.add((RelDataTypeField)fieldList.get(field));
        }
        return builder.build();
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(((double)this.fields.length + 2.0) / ((double)this.table.getRowType().getFieldCount() + 2.0));
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        JavaTypeFactory typeFactory = implementor.getTypeFactory();
        ParameterExpression rootExpression = implementor.getRootExpression();
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)typeFactory, (RelDataType)this.getRowType(), (JavaRowFormat)pref.preferArray());
        Expression tableExpression = this.table.getExpression(CalciteTable.class);
        MethodCallExpression methodCallExpression = Expressions.call((Expression)tableExpression, (String)"project", (Expression[])new Expression[]{rootExpression, this.fieldExpression});
        BlockStatement blockStatement = Blocks.toBlock((Node)methodCallExpression);
        return implementor.result(physType, blockStatement);
    }
}

