/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.sql;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.config.Lex;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.nifi.sql.NiFiTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteDatabase
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(CalciteDatabase.class);
    private final CalciteConnection connection;
    private final Map<String, NiFiTable> tables = new HashMap<String, NiFiTable>();

    public CalciteDatabase() throws SQLException {
        this(null);
    }

    public CalciteDatabase(Properties calciteConnectionProperties) throws SQLException {
        this.connection = this.createConnection(calciteConnectionProperties);
    }

    public void addTable(NiFiTable table) {
        if (this.tables.containsKey(table.getName())) {
            throw new IllegalStateException("Database already contains a table named " + table.getName());
        }
        this.connection.getRootSchema().add(table.getName(), (Table)table.createCalciteTable());
        this.tables.put(table.getName(), table);
    }

    public NiFiTable getTable(String tableName) {
        return this.tables.get(tableName);
    }

    public Collection<NiFiTable> getTables() {
        return Collections.unmodifiableCollection(this.tables.values());
    }

    public NiFiTable removeTable(String tableName) {
        NiFiTable table = this.tables.remove(tableName);
        if (table == null) {
            return null;
        }
        this.connection.getRootSchema().removeTable(tableName);
        return table;
    }

    public void addUserDefinedFunction(String functionName, Class<?> functionClass, String methodName) {
        this.connection.getRootSchema().add(functionName, (Function)ScalarFunctionImpl.create(functionClass, (String)methodName));
    }

    public void addUserDefinedFunction(String functionName, Method method) {
        this.connection.getRootSchema().add(functionName, (Function)ScalarFunctionImpl.create((Method)method));
    }

    public Connection getConnection() {
        return this.connection;
    }

    private CalciteConnection createConnection(Properties properties) throws SQLException {
        Properties calciteProperties;
        if (properties == null) {
            calciteProperties = new Properties();
            calciteProperties.put(CalciteConnectionProperty.LEX.camelName(), Lex.MYSQL_ANSI.name());
        } else {
            calciteProperties = properties;
        }
        calciteProperties.putIfAbsent("timeZone", "UTC");
        Connection sqlConnection = DriverManager.getConnection("jdbc:calcite:", calciteProperties);
        CalciteConnection connection = sqlConnection.unwrap(CalciteConnection.class);
        connection.getRootSchema().setCacheEnabled(false);
        return connection;
    }

    @Override
    public void close() throws IOException {
        for (NiFiTable table : this.getTables()) {
            try {
                table.close();
            }
            catch (Exception e) {
                logger.warn("Encountered failure when attempting to close {}", (Object)table, (Object)e);
            }
        }
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    static {
        try {
            DriverManager.registerDriver((Driver)new org.apache.calcite.jdbc.Driver());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize Calcite JDBC Driver");
        }
    }
}

