/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.box.controllerservices;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIResponseException;
import com.box.sdk.BoxConfig;
import com.box.sdk.BoxDeveloperEditionAPIConnection;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.box.controllerservices.BoxAppActor;
import org.apache.nifi.box.controllerservices.BoxClientService;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.VerifiableControllerService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.JsonValidator;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;

@CapabilityDescription(value="Provides Box client objects through which Box API calls can be used.")
@Tags(value={"box", "client", "provider"})
public class JsonConfigBasedBoxClientService
extends AbstractControllerService
implements BoxClientService,
VerifiableControllerService {
    public static final PropertyDescriptor APP_ACTOR = new PropertyDescriptor.Builder().name("App Actor").description("Specifies on behalf of whom Box API calls will be made.").required(true).allowableValues(BoxAppActor.class).defaultValue((DescribedValue)BoxAppActor.IMPERSONATED_USER).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final PropertyDescriptor ACCOUNT_ID = new PropertyDescriptor.Builder().name("box-account-id").displayName("Account ID").description("The ID of the Box account which the app will act on behalf of.").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dependsOn(APP_ACTOR, (DescribedValue)BoxAppActor.IMPERSONATED_USER, new DescribedValue[0]).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor APP_CONFIG_FILE = new PropertyDescriptor.Builder().name("app-config-file").displayName("App Config File").description("Full path of an App config JSON file. See Additional Details for more information.").required(false).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor APP_CONFIG_JSON = new PropertyDescriptor.Builder().name("app-config-json").displayName("App Config JSON").description("The raw JSON containing an App config. See Additional Details for more information.").required(false).sensitive(true).addValidator((Validator)JsonValidator.INSTANCE).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    static final PropertyDescriptor CONNECT_TIMEOUT = new PropertyDescriptor.Builder().name("Connect Timeout").description("Maximum amount of time to wait before failing during initial socket connection.").required(true).defaultValue("10 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    static final PropertyDescriptor READ_TIMEOUT = new PropertyDescriptor.Builder().name("Read Timeout").description("Maximum amount of time to wait before failing while reading socket responses.").required(true).defaultValue("30 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    private static final ProxySpec[] PROXY_SPECS = new ProxySpec[]{ProxySpec.HTTP, ProxySpec.HTTP_AUTH};
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(APP_ACTOR, ACCOUNT_ID, APP_CONFIG_FILE, APP_CONFIG_JSON, CONNECT_TIMEOUT, READ_TIMEOUT, ProxyConfiguration.createProxyConfigPropertyDescriptor((ProxySpec[])PROXY_SPECS));
    private volatile BoxAPIConnection boxAPIConnection;

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public List<ConfigVerificationResult> verify(ConfigurationContext configurationContext, ComponentLog componentLog, Map<String, String> map) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        try {
            this.createBoxApiConnection(configurationContext);
            results.add(new ConfigVerificationResult.Builder().verificationStepName("Authentication").outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation("JSON App config verified").build());
        }
        catch (Exception e) {
            results.add(new ConfigVerificationResult.Builder().verificationStepName("Authentication").outcome(ConfigVerificationResult.Outcome.FAILED).explanation("JSON App config failed to verify: " + e.getMessage()).build());
        }
        return results;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.boxAPIConnection = this.createBoxApiConnection(context);
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        if (validationContext.getProperty(APP_CONFIG_FILE).isSet() && validationContext.getProperty(APP_CONFIG_JSON).isSet()) {
            validationResults.add(new ValidationResult.Builder().subject("App configuration").valid(false).explanation(String.format("'%s' and '%s' cannot be configured at the same time", APP_CONFIG_FILE.getDisplayName(), APP_CONFIG_JSON.getDisplayName())).build());
        }
        if (!validationContext.getProperty(APP_CONFIG_FILE).isSet() && !validationContext.getProperty(APP_CONFIG_JSON).isSet()) {
            validationResults.add(new ValidationResult.Builder().subject("App configuration").valid(false).explanation(String.format("either '%s' or '%s' must be configured", APP_CONFIG_FILE.getDisplayName(), APP_CONFIG_JSON.getDisplayName())).build());
        }
        return validationResults;
    }

    public BoxAPIConnection getBoxApiConnection() {
        return this.boxAPIConnection;
    }

    private BoxAPIConnection createBoxApiConnection(ConfigurationContext context) {
        BoxDeveloperEditionAPIConnection api;
        BoxConfig boxConfig;
        ProxyConfiguration proxyConfiguration;
        block18: {
            proxyConfiguration = ProxyConfiguration.getConfiguration((PropertyContext)context);
            if (context.getProperty(APP_CONFIG_FILE).isSet()) {
                String appConfigFile = context.getProperty(APP_CONFIG_FILE).evaluateAttributeExpressions().getValue();
                try (FileReader reader = new FileReader(appConfigFile);){
                    boxConfig = BoxConfig.readFrom((Reader)reader);
                    break block18;
                }
                catch (FileNotFoundException e) {
                    throw new ProcessException("Couldn't find Box config file", (Throwable)e);
                }
                catch (IOException e) {
                    throw new ProcessException("Couldn't read Box config file", (Throwable)e);
                }
            }
            String appConfig = context.getProperty(APP_CONFIG_JSON).evaluateAttributeExpressions().getValue();
            boxConfig = BoxConfig.readFrom((String)appConfig);
        }
        try {
            api = BoxDeveloperEditionAPIConnection.getAppEnterpriseConnection((BoxConfig)boxConfig);
        }
        catch (BoxAPIResponseException e) {
            if (boxConfig.getEnterpriseId().equals("0")) {
                throw new BoxAPIException("Box API integration is not enabled for account, the account's enterprise ID cannot be 0", (Throwable)e);
            }
            throw e;
        }
        BoxAppActor appActor = (BoxAppActor)context.getProperty(APP_ACTOR).asAllowableValue(BoxAppActor.class);
        switch (appActor) {
            case SERVICE_ACCOUNT: {
                api.asSelf();
                break;
            }
            case IMPERSONATED_USER: {
                String accountId = context.getProperty(ACCOUNT_ID).evaluateAttributeExpressions().getValue();
                api.asUser(accountId);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized App actor:" + String.valueOf((Object)appActor));
            }
        }
        if (!Proxy.Type.DIRECT.equals((Object)proxyConfiguration.getProxyType())) {
            api.setProxy(proxyConfiguration.createProxy());
            if (proxyConfiguration.hasCredential()) {
                api.setProxyBasicAuthentication(proxyConfiguration.getProxyUserName(), proxyConfiguration.getProxyUserPassword());
            }
        }
        api.setConnectTimeout(context.getProperty(CONNECT_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue());
        api.setReadTimeout(context.getProperty(READ_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue());
        return api;
    }
}

