/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.box;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIResponseException;
import com.box.sdk.BoxFile;
import com.box.sdk.Metadata;
import com.eclipsesource.json.JsonValue;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.box.controllerservices.BoxClientService;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.box.AbstractBoxProcessor;
import org.apache.nifi.processors.box.FetchBoxFile;
import org.apache.nifi.processors.box.ListBoxFile;
import org.apache.nifi.processors.box.ListBoxFileMetadataTemplates;
import org.apache.nifi.processors.box.utils.BoxDate;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"box", "storage", "metadata", "templates", "update"})
@CapabilityDescription(value=" Updates metadata template values for a Box file using the record in the given flowFile. \n This record represents the desired end state of the template after the update. \n The processor will calculate the necessary changes (add/replace/remove) to transform\n the current metadata to the desired state. The input record should be a flat key-value object.\n")
@SeeAlso(value={ListBoxFileMetadataTemplates.class, ListBoxFile.class, FetchBoxFile.class})
@WritesAttributes(value={@WritesAttribute(attribute="box.id", description="The ID of the file whose metadata was updated"), @WritesAttribute(attribute="box.template.name", description="The template name used for metadata update"), @WritesAttribute(attribute="box.template.scope", description="The template scope used for metadata update"), @WritesAttribute(attribute="error.code", description="The error code returned by Box"), @WritesAttribute(attribute="error.message", description="The error message returned by Box")})
public class UpdateBoxFileMetadataInstance
extends AbstractBoxProcessor {
    public static final PropertyDescriptor FILE_ID = new PropertyDescriptor.Builder().name("File ID").description("The ID of the file for which to update metadata.").required(true).defaultValue("${box.id}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor TEMPLATE_KEY = new PropertyDescriptor.Builder().name("Template Key").description("The key of the metadata template to update.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor RECORD_READER = new PropertyDescriptor.Builder().name("Record Reader").description("The Record Reader to use for parsing the incoming data").required(true).identifiesControllerService(RecordReaderFactory.class).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile is routed to this relationship after metadata has been successfully updated.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile is routed to this relationship if an error occurs during metadata update.").build();
    public static final Relationship REL_FILE_NOT_FOUND = new Relationship.Builder().name("file not found").description("FlowFiles for which the specified Box file was not found will be routed to this relationship.").build();
    public static final Relationship REL_TEMPLATE_NOT_FOUND = new Relationship.Builder().name("template not found").description("FlowFiles for which the specified metadata template was not found will be routed to this relationship.").build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(BOX_CLIENT_SERVICE, FILE_ID, TEMPLATE_KEY, RECORD_READER);
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE, REL_FILE_NOT_FOUND, REL_TEMPLATE_NOT_FOUND);
    private volatile BoxAPIConnection boxAPIConnection;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        BoxClientService boxClientService = (BoxClientService)context.getProperty(BOX_CLIENT_SERVICE).asControllerService(BoxClientService.class);
        this.boxAPIConnection = boxClientService.getBoxApiConnection();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String fileId = context.getProperty(FILE_ID).evaluateAttributeExpressions(flowFile).getValue();
        String templateKey = context.getProperty(TEMPLATE_KEY).evaluateAttributeExpressions(flowFile).getValue();
        RecordReaderFactory recordReaderFactory = (RecordReaderFactory)context.getProperty(RECORD_READER).asControllerService(RecordReaderFactory.class);
        try {
            BoxFile boxFile = this.getBoxFile(fileId);
            Map<String, Object> desiredState = this.readDesiredState(session, flowFile, recordReaderFactory);
            if (desiredState.isEmpty()) {
                flowFile = session.putAttribute(flowFile, "error.message", "No valid metadata key-value pairs found in the input");
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
            Metadata metadata = this.getMetadata(boxFile, templateKey);
            this.updateMetadata(metadata, desiredState);
            if (!metadata.getOperations().isEmpty()) {
                this.getLogger().info("Updating {} metadata fields for file {}", new Object[]{metadata.getOperations().size(), fileId});
                this.updateBoxFileMetadata(boxFile, metadata);
            }
            Map<String, String> attributes = Map.of("box.id", fileId, "box.template.key", templateKey);
            flowFile = session.putAllAttributes(flowFile, attributes);
            session.getProvenanceReporter().modifyAttributes(flowFile, "%s%s/metadata/enterprise/%s".formatted("https://app.box.com/file/", fileId, templateKey));
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (BoxAPIResponseException e) {
            flowFile = session.putAttribute(flowFile, "error.code", String.valueOf(e.getResponseCode()));
            flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
            String errorBody = e.getResponse();
            if (errorBody != null && errorBody.toLowerCase().contains("specified metadata template not found")) {
                this.getLogger().warn("Box metadata template with key {} was not found.", new Object[]{templateKey});
                session.transfer(flowFile, REL_TEMPLATE_NOT_FOUND);
            } else {
                this.getLogger().warn("Box file with ID {} was not found.", new Object[]{fileId});
                session.transfer(flowFile, REL_FILE_NOT_FOUND);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Error processing metadata update for Box file [{}]", new Object[]{fileId, e});
            flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private Map<String, Object> readDesiredState(ProcessSession session, FlowFile flowFile, RecordReaderFactory recordReaderFactory) throws Exception {
        HashMap<String, Object> desiredState = new HashMap<String, Object>();
        try (InputStream inputStream = session.read(flowFile);
             RecordReader recordReader = recordReaderFactory.createRecordReader(flowFile, inputStream, this.getLogger());){
            Record record = recordReader.nextRecord();
            if (record != null) {
                List fields = record.getSchema().getFields();
                for (RecordField field : fields) {
                    String fieldName = field.getFieldName();
                    RecordFieldType type = field.getDataType().getFieldType();
                    Object value = RecordFieldType.DATE.equals((Object)type) ? record.getAsLocalDate(fieldName, null) : record.getValue(field);
                    desiredState.put(fieldName, value);
                }
            }
        }
        return desiredState;
    }

    private void updateMetadata(Metadata metadata, Map<String, Object> desiredState) {
        String fieldName;
        List currentKeys = metadata.getPropertyPaths();
        for (String string : currentKeys) {
            fieldName = string.substring(1);
            if (desiredState.containsKey(fieldName)) continue;
            metadata.remove(string);
            this.getLogger().debug("Removing metadata field: {}", new Object[]{fieldName});
        }
        for (Map.Entry entry : desiredState.entrySet()) {
            fieldName = (String)entry.getKey();
            Object value = entry.getValue();
            String propertyPath = "/" + fieldName;
            this.updateField(metadata, propertyPath, value, currentKeys.contains(propertyPath));
        }
    }

    private void updateField(Metadata metadata, String propertyPath, Object value, boolean exists) {
        if (value == null) {
            throw new IllegalArgumentException("Null value found for property path: " + propertyPath);
        }
        if (exists) {
            JsonValue currentValue = metadata.getValue(propertyPath);
            if (Objects.equals(currentValue, value)) {
                return;
            }
            Object object = value;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, List.class, LocalDate.class}, (Object)object2, n)) {
                case 0: {
                    Number n2 = (Number)object2;
                    metadata.replace(propertyPath, n2.doubleValue());
                    break;
                }
                case 1: {
                    List l = (List)object2;
                    metadata.replace(propertyPath, this.convertListToStringList(l, propertyPath));
                    break;
                }
                case 2: {
                    LocalDate d = (LocalDate)object2;
                    metadata.replace(propertyPath, BoxDate.of(d).format());
                    break;
                }
                default: {
                    metadata.replace(propertyPath, value.toString());
                    break;
                }
            }
        } else {
            Object object = value;
            Objects.requireNonNull(object);
            Object object3 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, List.class, LocalDate.class}, (Object)object3, n)) {
                case 0: {
                    Number n3 = (Number)object3;
                    metadata.add(propertyPath, n3.doubleValue());
                    break;
                }
                case 1: {
                    List l = (List)object3;
                    metadata.add(propertyPath, this.convertListToStringList(l, propertyPath));
                    break;
                }
                case 2: {
                    LocalDate d = (LocalDate)object3;
                    metadata.add(propertyPath, BoxDate.of(d).format());
                    break;
                }
                default: {
                    metadata.add(propertyPath, value.toString());
                }
            }
        }
    }

    private List<String> convertListToStringList(List<?> list, String fieldName) {
        return list.stream().map(obj -> {
            if (obj == null) {
                throw new IllegalArgumentException("Null value found in list for field: " + fieldName);
            }
            return obj.toString();
        }).collect(Collectors.toList());
    }

    Metadata getMetadata(BoxFile boxFile, String templateKey) {
        return boxFile.getMetadata(templateKey);
    }

    BoxFile getBoxFile(String fileId) {
        return new BoxFile(this.boxAPIConnection, fileId);
    }

    void updateBoxFileMetadata(BoxFile boxFile, Metadata metadata) {
        boxFile.updateMetadata(metadata);
    }
}

