/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.box;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIResponseException;
import com.box.sdk.BoxFile;
import com.box.sdk.Metadata;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.box.controllerservices.BoxClientService;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.box.AbstractBoxProcessor;
import org.apache.nifi.processors.box.BoxMetadataJsonArrayWriter;
import org.apache.nifi.processors.box.FetchBoxFile;
import org.apache.nifi.processors.box.FetchBoxFileInfo;
import org.apache.nifi.processors.box.ListBoxFile;
import org.apache.nifi.processors.box.utils.BoxMetadataUtils;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"box", "storage", "metadata", "instances", "templates"})
@CapabilityDescription(value="Retrieves all metadata instances associated with a Box file.")
@SeeAlso(value={ListBoxFile.class, FetchBoxFile.class, FetchBoxFileInfo.class})
@WritesAttributes(value={@WritesAttribute(attribute="box.id", description="The ID of the file from which metadata was fetched"), @WritesAttribute(attribute="record.count", description="The number of records in the FlowFile"), @WritesAttribute(attribute="mime.type", description="The MIME Type specified by the Record Writer"), @WritesAttribute(attribute="box.metadata.instances.names", description="Comma-separated list of instances names"), @WritesAttribute(attribute="box.metadata.instances.count", description="Number of metadata instances found"), @WritesAttribute(attribute="error.code", description="The error code returned by Box"), @WritesAttribute(attribute="error.message", description="The error message returned by Box")})
public class ListBoxFileMetadataInstances
extends AbstractBoxProcessor {
    public static final PropertyDescriptor FILE_ID = new PropertyDescriptor.Builder().name("File ID").description("The ID of the file for which to fetch metadata.").required(true).defaultValue("${box.id}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile containing the metadata instances records will be routed to this relationship upon successful processing.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile will be routed here if there is an error fetching metadata instances from the file.").build();
    public static final Relationship REL_NOT_FOUND = new Relationship.Builder().name("not found").description("FlowFiles for which the specified Box file was not found will be routed to this relationship.").build();
    public static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE, REL_NOT_FOUND);
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(BOX_CLIENT_SERVICE, FILE_ID);
    private volatile BoxAPIConnection boxAPIConnection;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        BoxClientService boxClientService = (BoxClientService)context.getProperty(BOX_CLIENT_SERVICE).asControllerService(BoxClientService.class);
        this.boxAPIConnection = boxClientService.getBoxApiConnection();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String fileId = context.getProperty(FILE_ID).evaluateAttributeExpressions(flowFile).getValue();
        try {
            BoxFile boxFile = this.getBoxFile(fileId);
            ArrayList<HashMap<String, Object>> instanceList = new ArrayList<HashMap<String, Object>>();
            Iterable metadataList = boxFile.getAllMetadata(new String[0]);
            Iterator iterator = metadataList.iterator();
            LinkedHashSet<String> templateNames = new LinkedHashSet<String>();
            if (!iterator.hasNext()) {
                flowFile = session.putAttribute(flowFile, "box.id", fileId);
                flowFile = session.putAttribute(flowFile, "box.metadata.instances.count", "0");
                session.transfer(flowFile, REL_SUCCESS);
                return;
            }
            while (iterator.hasNext()) {
                Metadata metadata = (Metadata)iterator.next();
                HashMap<String, Object> instanceFields = new HashMap<String, Object>();
                templateNames.add(metadata.getTemplateName());
                BoxMetadataUtils.processBoxMetadataInstance(fileId, metadata, instanceFields);
                instanceList.add(instanceFields);
            }
            try {
                try (OutputStream out = session.write(flowFile);
                     BoxMetadataJsonArrayWriter writer = BoxMetadataJsonArrayWriter.create(out);){
                    for (Map map : instanceList) {
                        writer.write(map);
                    }
                }
                HashMap<String, String> recordAttributes = new HashMap<String, String>();
                recordAttributes.put("record.count", String.valueOf(instanceList.size()));
                recordAttributes.put(CoreAttributes.MIME_TYPE.key(), "application/json");
                recordAttributes.put("box.id", fileId);
                recordAttributes.put("box.metadata.instances.names", String.join((CharSequence)",", templateNames));
                recordAttributes.put("box.metadata.instances.count", String.valueOf(instanceList.size()));
                flowFile = session.putAllAttributes(flowFile, recordAttributes);
                session.getProvenanceReporter().receive(flowFile, "https://app.box.com/file/" + fileId + "/metadata");
                session.transfer(flowFile, REL_SUCCESS);
            }
            catch (IOException e) {
                this.getLogger().error("Failed writing metadata instances from file [{}]", new Object[]{fileId, e});
                flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
                session.transfer(flowFile, REL_FAILURE);
            }
        }
        catch (BoxAPIResponseException e) {
            flowFile = session.putAttribute(flowFile, "error.code", String.valueOf(e.getResponseCode()));
            flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
            if (e.getResponseCode() == 404) {
                this.getLogger().warn("Box file with ID {} was not found.", new Object[]{fileId});
                session.transfer(flowFile, REL_NOT_FOUND);
            } else {
                this.getLogger().error("Couldn't fetch metadata instances from file with id [{}]", new Object[]{fileId, e});
                session.transfer(flowFile, REL_FAILURE);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Failed to process metadata instances for file [{}]", new Object[]{fileId, e});
            flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    BoxFile getBoxFile(String fileId) {
        return new BoxFile(this.boxAPIConnection, fileId);
    }
}

