/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.box;

import com.box.sdk.BoxEvent;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

final class BoxEventJsonArrayWriter
implements Closeable {
    private final Writer writer;
    private boolean hasBegun;
    private boolean hasEntries;
    private boolean closed;

    private BoxEventJsonArrayWriter(Writer writer) {
        this.writer = writer;
        this.hasBegun = false;
        this.hasEntries = false;
        this.closed = false;
    }

    static BoxEventJsonArrayWriter create(OutputStream outputStream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        return new BoxEventJsonArrayWriter(writer);
    }

    void write(BoxEvent event) throws IOException {
        if (this.closed) {
            throw new IOException("The Writer is closed");
        }
        if (!this.hasBegun) {
            this.beginArray();
            this.hasBegun = true;
        }
        if (this.hasEntries) {
            this.writer.write(44);
        }
        JsonObject json = this.toRecord(event);
        json.writeTo(this.writer);
        this.hasEntries = true;
    }

    private JsonObject toRecord(BoxEvent event) {
        JsonObject json = Json.object();
        json.add("accessibleBy", event.getAccessibleBy() == null ? Json.NULL : Json.parse((String)event.getAccessibleBy().getJson()));
        json.add("actionBy", event.getActionBy() == null ? Json.NULL : Json.parse((String)event.getActionBy().getJson()));
        json.add("additionalDetails", Objects.requireNonNullElse(event.getAdditionalDetails(), Json.NULL));
        json.add("createdAt", event.getCreatedAt() == null ? Json.NULL : Json.value((String)event.getCreatedAt().toString()));
        json.add("createdBy", event.getCreatedBy() == null ? Json.NULL : Json.parse((String)event.getCreatedBy().getJson()));
        json.add("eventType", event.getEventType() == null ? Json.NULL : Json.value((String)event.getEventType().name()));
        json.add("id", Objects.requireNonNullElse(Json.value((String)event.getID()), Json.NULL));
        json.add("ipAddress", Objects.requireNonNullElse(Json.value((String)event.getIPAddress()), Json.NULL));
        json.add("sessionID", Objects.requireNonNullElse(Json.value((String)event.getSessionID()), Json.NULL));
        json.add("source", Objects.requireNonNullElse(event.getSourceJSON(), Json.NULL));
        json.add("typeName", Objects.requireNonNullElse(Json.value((String)event.getTypeName()), Json.NULL));
        return json;
    }

    private void beginArray() throws IOException {
        this.writer.write(91);
    }

    private void endArray() throws IOException {
        this.writer.write(93);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!this.hasBegun) {
            this.beginArray();
        }
        this.endArray();
        this.writer.close();
    }
}

