/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.azure.loganalytics;

import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.lang.runtime.SwitchBootstraps;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnUnscheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.azure.loganalytics.AbstractAzureLogAnalyticsReportingTask;
import org.apache.nifi.reporting.util.provenance.ProvenanceEventConsumer;

@Tags(value={"azure", "provenace", "reporting", "log analytics"})
@CapabilityDescription(value="Publishes Provenance events to to a Azure Log Analytics workspace.")
public class AzureLogAnalyticsProvenanceReportingTask
extends AbstractAzureLogAnalyticsReportingTask {
    protected static final String LAST_EVENT_ID_KEY = "last_event_id";
    protected static final String DESTINATION_URL_PATH = "/nifi";
    protected static final String TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    static final PropertyDescriptor LOG_ANALYTICS_CUSTOM_LOG_NAME = new PropertyDescriptor.Builder().name("Log Analytics Custom Log Name").description("Log Analytics Custom Log Name").required(false).defaultValue("nifiprovenance").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    static final AllowableValue BEGINNING_OF_STREAM = new AllowableValue("beginning-of-stream", "Beginning of Stream", "Start reading provenance Events from the beginning of the stream (the oldest event first)");
    static final AllowableValue END_OF_STREAM = new AllowableValue("end-of-stream", "End of Stream", "Start reading provenance Events from the end of the stream, ignoring old events");
    static final PropertyDescriptor FILTER_EVENT_TYPE = new PropertyDescriptor.Builder().name("Event Type to Include").description("Comma-separated list of event types that will be used to filter the provenance events sent by the reporting task. Available event types are " + Arrays.deepToString(ProvenanceEventType.values()) + ". If no filter is set, all the events are sent. If multiple filters are set, the filters are cumulative.").required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor FILTER_EVENT_TYPE_EXCLUDE = new PropertyDescriptor.Builder().name("Event Type to Exclude").description("Comma-separated list of event types that will be used to exclude the provenance events sent by the reporting task. Available event types are " + Arrays.deepToString(ProvenanceEventType.values()) + ". If no filter is set, all the events are sent. If multiple filters are set, the filters are cumulative. If an event type is included in Event Type to Include and excluded here, then the exclusion takes precedence and the event will not be sent.").required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor FILTER_COMPONENT_TYPE = new PropertyDescriptor.Builder().name("Component Type to Include").description("Regular expression to filter the provenance events based on the component type. Only the events matching the regular expression will be sent. If no filter is set, all the events are sent. If multiple filters are set, the filters are cumulative.").required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).build();
    static final PropertyDescriptor FILTER_COMPONENT_TYPE_EXCLUDE = new PropertyDescriptor.Builder().name("Component Type to Exclude").description("Regular expression to exclude the provenance events based on the component type. The events matching the regular expression will not be sent. If no filter is set, all the events are sent. If multiple filters are set, the filters are cumulative. If a component type is included in Component Type to Include and excluded here, then the exclusion takes precedence and the event will not be sent.").required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).build();
    static final PropertyDescriptor FILTER_COMPONENT_ID = new PropertyDescriptor.Builder().name("Component ID to Include").description("Comma-separated list of component UUID that will be used to filter the provenance events sent by the reporting task. If no filter is set, all the events are sent. If multiple filters are set, the filters are cumulative.").required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor FILTER_COMPONENT_ID_EXCLUDE = new PropertyDescriptor.Builder().name("Component ID to Exclude").description("Comma-separated list of component UUID that will be used to exclude the provenance events sent by the reporting task. If no filter is set, all the events are sent. If multiple filters are set, the filters are cumulative. If a component UUID is included in Component ID to Include and excluded here, then the exclusion takes precedence and the event will not be sent.").required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor FILTER_COMPONENT_NAME = new PropertyDescriptor.Builder().name("Component Name to Include").description("Regular expression to filter the provenance events based on the component name. Only the events matching the regular expression will be sent. If no filter is set, all the events are sent. If multiple filters are set, the filters are cumulative.").required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).build();
    static final PropertyDescriptor FILTER_COMPONENT_NAME_EXCLUDE = new PropertyDescriptor.Builder().name("Component Name to Exclude").description("Regular expression to exclude the provenance events based on the component name. The events matching the regular expression will not be sent. If no filter is set, all the events are sent. If multiple filters are set, the filters are cumulative. If a component name is included in Component Name to Include and excluded here, then the exclusion takes precedence and the event will not be sent.").required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).build();
    static final PropertyDescriptor START_POSITION = new PropertyDescriptor.Builder().name("Start Position").description("If the Reporting Task has never been run, or if its state has been reset by a user, specifies where in the stream of Provenance Events the Reporting Task should start").allowableValues(new DescribedValue[]{BEGINNING_OF_STREAM, END_OF_STREAM}).defaultValue((DescribedValue)BEGINNING_OF_STREAM).required(true).build();
    static final PropertyDescriptor ALLOW_NULL_VALUES = new PropertyDescriptor.Builder().name("Include Null Values").description("Indicate if null values should be included in records. Default will be false").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    static final PropertyDescriptor PLATFORM = new PropertyDescriptor.Builder().name("Platform").description("The value to use for the platform field in each event.").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).defaultValue("nifi").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor INSTANCE_URL = new PropertyDescriptor.Builder().name("Instance URL").description("The URL of this instance to use in the Content URI of each event.").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).defaultValue("http://${hostname(true)}:8080/nifi").addValidator(StandardValidators.URL_VALIDATOR).build();
    static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("Batch Size").description("Specifies how many records to send in a single batch, at most.").required(true).defaultValue("1000").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(LOG_ANALYTICS_WORKSPACE_ID, LOG_ANALYTICS_CUSTOM_LOG_NAME, LOG_ANALYTICS_WORKSPACE_KEY, APPLICATION_ID, INSTANCE_ID, JOB_NAME, LOG_ANALYTICS_URL_ENDPOINT_FORMAT, FILTER_EVENT_TYPE, FILTER_EVENT_TYPE_EXCLUDE, FILTER_COMPONENT_TYPE, FILTER_COMPONENT_TYPE_EXCLUDE, FILTER_COMPONENT_ID, FILTER_COMPONENT_ID_EXCLUDE, FILTER_COMPONENT_NAME, FILTER_COMPONENT_NAME_EXCLUDE, START_POSITION, ALLOW_NULL_VALUES, PLATFORM, INSTANCE_URL, BATCH_SIZE);
    private volatile ProvenanceEventConsumer consumer;

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void CreateConsumer(ReportingContext context) {
        String[] targetComponentIdsExclude;
        String[] targetComponentIds;
        String[] targetEventTypesExclude;
        if (this.consumer != null) {
            return;
        }
        this.consumer = new ProvenanceEventConsumer();
        this.consumer.setStartPositionValue(context.getProperty(START_POSITION).getValue());
        this.consumer.setBatchSize(context.getProperty(BATCH_SIZE).asInteger().intValue());
        this.consumer.setLogger(this.getLogger());
        this.consumer.setComponentTypeRegex(context.getProperty(FILTER_COMPONENT_TYPE).evaluateAttributeExpressions().getValue());
        this.consumer.setComponentTypeRegexExclude(context.getProperty(FILTER_COMPONENT_TYPE_EXCLUDE).evaluateAttributeExpressions().getValue());
        this.consumer.setComponentNameRegex(context.getProperty(FILTER_COMPONENT_NAME).evaluateAttributeExpressions().getValue());
        this.consumer.setComponentNameRegexExclude(context.getProperty(FILTER_COMPONENT_NAME_EXCLUDE).evaluateAttributeExpressions().getValue());
        String[] targetEventTypes = StringUtils.stripAll((String[])StringUtils.split((String)context.getProperty(FILTER_EVENT_TYPE).evaluateAttributeExpressions().getValue(), (char)','));
        if (targetEventTypes != null) {
            for (String type : targetEventTypes) {
                try {
                    this.consumer.addTargetEventType(new ProvenanceEventType[]{ProvenanceEventType.valueOf((String)type)});
                }
                catch (Exception e) {
                    this.getLogger().warn(type + " is not a correct event type, removed from the filtering.");
                }
            }
        }
        if ((targetEventTypesExclude = StringUtils.stripAll((String[])StringUtils.split((String)context.getProperty(FILTER_EVENT_TYPE_EXCLUDE).evaluateAttributeExpressions().getValue(), (char)','))) != null) {
            for (String type : targetEventTypesExclude) {
                try {
                    this.consumer.addTargetEventTypeExclude(new ProvenanceEventType[]{ProvenanceEventType.valueOf((String)type)});
                }
                catch (Exception e) {
                    this.getLogger().warn(type + " is not a correct event type, removed from the exclude filtering.");
                }
            }
        }
        if ((targetComponentIds = StringUtils.stripAll((String[])StringUtils.split((String)context.getProperty(FILTER_COMPONENT_ID).evaluateAttributeExpressions().getValue(), (char)','))) != null) {
            this.consumer.addTargetComponentId(targetComponentIds);
        }
        if ((targetComponentIdsExclude = StringUtils.stripAll((String[])StringUtils.split((String)context.getProperty(FILTER_COMPONENT_ID_EXCLUDE).evaluateAttributeExpressions().getValue(), (char)','))) != null) {
            this.consumer.addTargetComponentIdExclude(targetComponentIdsExclude);
        }
        this.consumer.setScheduled(true);
    }

    public void onTrigger(ReportingContext context) {
        boolean isClustered = context.isClustered();
        String nodeId = context.getClusterNodeIdentifier();
        if (nodeId == null && isClustered) {
            this.getLogger().debug("This instance of NiFi is configured for clustering, but the Cluster Node Identifier is not yet available. Will wait for Node Identifier to be established.");
            return;
        }
        try {
            this.processProvenanceData(context);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to publish metrics to Azure Log Analytics", (Throwable)e);
        }
    }

    @Override
    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("s2s-prov-task-event-filter", FILTER_EVENT_TYPE.getName());
        config.renameProperty("s2s-prov-task-event-filter-exclude", FILTER_EVENT_TYPE_EXCLUDE.getName());
        config.renameProperty("s2s-prov-task-type-filter", FILTER_COMPONENT_TYPE.getName());
        config.renameProperty("s2s-prov-task-type-filter-exclude", FILTER_COMPONENT_TYPE_EXCLUDE.getName());
        config.renameProperty("s2s-prov-task-id-filter", FILTER_COMPONENT_ID.getName());
        config.renameProperty("s2s-prov-task-id-filter-exclude", FILTER_COMPONENT_ID_EXCLUDE.getName());
        config.renameProperty("s2s-prov-task-name-filter", FILTER_COMPONENT_NAME.getName());
        config.renameProperty("s2s-prov-task-name-filter-exclude", FILTER_COMPONENT_NAME_EXCLUDE.getName());
        config.renameProperty("start-position", START_POSITION.getName());
        config.renameProperty("include-null-values", ALLOW_NULL_VALUES.getName());
    }

    public void processProvenanceData(ReportingContext context) {
        URL url;
        this.getLogger().debug("Starting to process provenance data");
        String workspaceId = context.getProperty(LOG_ANALYTICS_WORKSPACE_ID).evaluateAttributeExpressions().getValue();
        String linuxPrimaryKey = context.getProperty(LOG_ANALYTICS_WORKSPACE_KEY).evaluateAttributeExpressions().getValue();
        String logName = context.getProperty(LOG_ANALYTICS_CUSTOM_LOG_NAME).evaluateAttributeExpressions().getValue();
        String urlEndpointFormat = context.getProperty(LOG_ANALYTICS_URL_ENDPOINT_FORMAT).evaluateAttributeExpressions().getValue();
        Integer batchSize = context.getProperty(BATCH_SIZE).asInteger();
        String dataCollectorEndpoint = MessageFormat.format(urlEndpointFormat, workspaceId);
        ProcessGroupStatus procGroupStatus = context.getEventAccess().getControllerStatus();
        String nodeId = context.getClusterNodeIdentifier();
        String rootGroupName = procGroupStatus == null ? null : procGroupStatus.getName();
        String platform = context.getProperty(PLATFORM).evaluateAttributeExpressions().getValue();
        Boolean allowNullValues = context.getProperty(ALLOW_NULL_VALUES).asBoolean();
        String nifiUrl = context.getProperty(INSTANCE_URL).evaluateAttributeExpressions().getValue();
        try {
            url = URI.create(nifiUrl).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new AssertionError();
        }
        String hostname = url.getHost();
        Map config = Collections.emptyMap();
        JsonBuilderFactory factory = Json.createBuilderFactory(config);
        JsonObjectBuilder builder = factory.createObjectBuilder();
        this.CreateConsumer(context);
        this.consumer.consumeEvents(context, (mapHolder, events) -> {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            for (ProvenanceEventRecord event : events) {
                String componentName = mapHolder.getComponentName(event.getComponentId());
                String processGroupId = mapHolder.getProcessGroupId(event.getComponentId(), event.getComponentType());
                String processGroupName = mapHolder.getComponentName(processGroupId);
                JsonObject jo = this.serialize(factory, builder, event, componentName, processGroupId, processGroupName, hostname, url, rootGroupName, platform, nodeId, allowNullValues);
                stringBuilder.append(jo.toString());
                stringBuilder.append(',');
            }
            if (stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            stringBuilder.append(']');
            String str = stringBuilder.toString();
            if (!str.equals("[]")) {
                HttpPost httpPost = new HttpPost(dataCollectorEndpoint);
                httpPost.addHeader("Content-Type", "application/json");
                httpPost.addHeader("Log-Type", logName);
                this.getLogger().debug("Sending {} events of length {} to azure log analytics {}", new Object[]{batchSize, str.length(), logName});
                try {
                    this.sendToLogAnalytics(httpPost, workspaceId, linuxPrimaryKey, str);
                }
                catch (Exception e) {
                    this.getLogger().error("Failed to publish provenance data to Azure Log Analytics", (Throwable)e);
                }
            }
        });
        this.getLogger().debug("Done processing provenance data");
    }

    private JsonObject serialize(JsonBuilderFactory factory, JsonObjectBuilder builder, ProvenanceEventRecord event, String componentName, String processGroupId, String processGroupName, String hostname, URL nifiUrl, String applicationName, String platform, String nodeIdentifier, Boolean allowNullValues) {
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "eventId", UUID.randomUUID().toString(), allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "eventOrdinal", event.getEventId(), allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "eventType", event.getEventType().name(), allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "timestampMillis", event.getEventTime(), allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "timestamp", DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(event.getEventTime()).atOffset(ZoneOffset.UTC)), allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "durationMillis", event.getEventDuration(), allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "lineageStart", event.getLineageStartDate(), allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "details", event.getDetails(), allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "componentId", event.getComponentId(), allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "componentType", event.getComponentType(), allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "componentName", componentName, allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "processGroupId", processGroupId, allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "processGroupName", processGroupName, allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "entityId", event.getFlowFileUuid(), allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "entityType", "org.apache.nifi.flowfile.FlowFile", allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "entitySize", event.getFileSize(), allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "previousEntitySize", event.getPreviousFileSize(), allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, factory, "updatedAttributes", event.getUpdatedAttributes(), allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, factory, "previousAttributes", event.getPreviousAttributes(), allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "actorHostname", hostname, allowNullValues);
        if (nifiUrl != null) {
            String urlString = nifiUrl.toString();
            String urlPrefix = urlString.substring(0, urlString.length() - DESTINATION_URL_PATH.length());
            String contentUriBase = urlPrefix + "/nifi-api/provenance-events/" + event.getEventId() + "/content/";
            Object nodeIdSuffix = nodeIdentifier == null ? "" : "?clusterNodeId=" + nodeIdentifier;
            AzureLogAnalyticsProvenanceReportingTask.addField(builder, "contentURI", contentUriBase + "output" + (String)nodeIdSuffix, allowNullValues);
            AzureLogAnalyticsProvenanceReportingTask.addField(builder, "previousContentURI", contentUriBase + "input" + (String)nodeIdSuffix, allowNullValues);
        }
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, factory, "parentIds", event.getParentUuids(), allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, factory, "childIds", event.getChildUuids(), allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "transitUri", event.getTransitUri(), allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "remoteIdentifier", event.getSourceSystemFlowFileIdentifier(), allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "alternateIdentifier", event.getAlternateIdentifierUri(), allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "platform", platform, allowNullValues);
        AzureLogAnalyticsProvenanceReportingTask.addField(builder, "application", applicationName, allowNullValues);
        return builder.build();
    }

    @OnUnscheduled
    public void onUnscheduled() {
        if (this.consumer != null) {
            this.getLogger().debug("Disabling schedule to consume provenance data.");
            this.consumer.setScheduled(false);
        }
    }

    public static void addField(JsonObjectBuilder builder, String key, Object value, boolean allowNullValues) {
        Object object = value;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Integer.class, Boolean.class, Long.class}, (Object)object, n)) {
            case 0: {
                String s = (String)object;
                builder.add(key, s);
                break;
            }
            case 1: {
                Integer i = (Integer)object;
                builder.add(key, i.intValue());
                break;
            }
            case 2: {
                Boolean b = (Boolean)object;
                builder.add(key, b.booleanValue());
                break;
            }
            case 3: {
                Long l = (Long)object;
                builder.add(key, l.longValue());
                break;
            }
            case -1: {
                if (!allowNullValues) break;
                builder.add(key, JsonValue.NULL);
                break;
            }
            default: {
                builder.add(key, value.toString());
            }
        }
    }

    public static void addField(JsonObjectBuilder builder, JsonBuilderFactory factory, String key, Map<String, String> values, Boolean allowNullValues) {
        if (values != null) {
            JsonObjectBuilder mapBuilder = factory.createObjectBuilder();
            for (Map.Entry<String, String> entry : values.entrySet()) {
                if (entry.getKey() == null) continue;
                if (entry.getValue() == null) {
                    if (!allowNullValues.booleanValue()) continue;
                    mapBuilder.add(entry.getKey(), JsonValue.NULL);
                    continue;
                }
                mapBuilder.add(entry.getKey(), entry.getValue());
            }
            builder.add(key, mapBuilder);
        } else if (allowNullValues.booleanValue()) {
            builder.add(key, JsonValue.NULL);
        }
    }

    public static void addField(JsonObjectBuilder builder, JsonBuilderFactory factory, String key, Collection<String> values, Boolean allowNullValues) {
        if (values != null) {
            builder.add(key, AzureLogAnalyticsProvenanceReportingTask.createJsonArray(factory, values));
        } else if (allowNullValues.booleanValue()) {
            builder.add(key, JsonValue.NULL);
        }
    }

    private static JsonArrayBuilder createJsonArray(JsonBuilderFactory factory, Collection<String> values) {
        JsonArrayBuilder builder = factory.createArrayBuilder();
        for (String value : values) {
            if (value == null) continue;
            builder.add(value);
        }
        return builder;
    }
}

