/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.azure.loganalytics.api;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.metrics.jvm.JvmMetrics;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.reporting.azure.loganalytics.Metric;
import org.apache.nifi.reporting.azure.loganalytics.MetricsBuilder;

public class AzureLogAnalyticsMetricsFactory {
    public static List<Metric> getDataFlowMetrics(ProcessGroupStatus status, String instanceId) {
        String groupId = status.getId();
        String groupName = status.getName();
        MetricsBuilder builder = new MetricsBuilder("DataFlow", instanceId, groupId, groupName);
        builder.metric("FlowFilesReceived", status.getFlowFilesReceived()).metric("FlowFilesSent", status.getFlowFilesSent()).metric("FlowFilesQueued", status.getQueuedCount()).metric("BytesReceived", status.getBytesReceived()).metric("BytesWritten", status.getBytesWritten()).metric("BytesRead", status.getBytesRead()).metric("BytesSent", status.getBytesSent()).metric("BytesQueued", status.getQueuedContentSize()).metric("ActiveThreads", status.getActiveThreadCount()).metric("TotalTaskDurationSeconds", AzureLogAnalyticsMetricsFactory.calculateProcessingNanos(status));
        return builder.build();
    }

    public static List<Metric> getConnectionStatusMetrics(ConnectionStatus status, String instanceId, String groupName) {
        String groupId = status.getGroupId();
        String tags = String.format("[source=%s][destination=%s][cname=%s]", status.getSourceName(), status.getDestinationName(), status.getName());
        MetricsBuilder builder = new MetricsBuilder("Connections", instanceId, groupId, groupName);
        builder.setTags(tags).metric("InputCount", status.getInputCount()).metric("InputBytes", status.getInputBytes()).metric("QueuedCount", status.getQueuedCount()).metric("QueuedBytes", status.getQueuedBytes()).metric("OutputCount", status.getOutputCount()).metric("OutputBytes", status.getOutputBytes());
        return builder.build();
    }

    public static List<Metric> getProcessorMetrics(ProcessorStatus status, String instanceId, String groupName) {
        MetricsBuilder builder = new MetricsBuilder("Processor", instanceId, status.getGroupId(), groupName);
        builder.setProcessorId(status.getId()).setProcessorName(status.getName()).metric("FlowFilesReceived", status.getInputCount()).metric("FlowFilesSent", status.getOutputCount()).metric("BytesRead", status.getInputBytes()).metric("BytesWritten", status.getOutputBytes()).metric("ActiveThreads", status.getActiveThreadCount()).metric("TotalTaskDurationSeconds", status.getProcessingNanos());
        return builder.build();
    }

    public static List<Metric> getJvmMetrics(JvmMetrics virtualMachineMetrics, String instanceId, String groupName) {
        MetricsBuilder builder = new MetricsBuilder("JvmMetrics", instanceId, "", groupName);
        builder.metric("jvm.heap_used", virtualMachineMetrics.heapUsed(DataUnit.B)).metric("jvm.heap_usage", virtualMachineMetrics.heapUsage()).metric("jvm.non_heap_usage", virtualMachineMetrics.nonHeapUsage()).metric("jvm.file_descriptor_usage", virtualMachineMetrics.fileDescriptorUsage()).metric("jvm.uptime", virtualMachineMetrics.uptime()).metric("jvm.thread_count", virtualMachineMetrics.threadCount()).metric("jvm.daemon_thread_count", virtualMachineMetrics.daemonThreadCount());
        virtualMachineMetrics.garbageCollectors().forEach((name, stat) -> {
            name = name.toLowerCase().replaceAll("\\s", "_");
            builder.metric("jvm.gc.runs." + name, stat.getRuns()).metric("jvm.gc.time." + name, stat.getTime(TimeUnit.MILLISECONDS));
        });
        virtualMachineMetrics.threadStatePercentages().forEach((state, usage) -> {
            String name = state.name().toLowerCase().replaceAll("\\s", "_");
            builder.metric("jvm.thread_states." + name, (double)usage);
        });
        virtualMachineMetrics.memoryPoolUsage().forEach((name, usage) -> {
            name = name.toLowerCase().replaceAll("\\s", "_");
            builder.metric("jvm.mem_pool_" + name, (double)usage);
        });
        return builder.build();
    }

    static long calculateProcessingNanos(ProcessGroupStatus status) {
        long nanos = 0L;
        for (ProcessorStatus procStats : status.getProcessorStatus()) {
            nanos += procStats.getProcessingNanos();
        }
        for (ProcessGroupStatus childGroupStatus : status.getProcessGroupStatus()) {
            nanos += AzureLogAnalyticsMetricsFactory.calculateProcessingNanos(childGroupStatus);
        }
        return nanos;
    }
}

